/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.database.actions;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.bimserver.BimServer;
import org.bimserver.BimserverDatabaseException;
import org.bimserver.database.BimserverLockConflictException;
import org.bimserver.database.DatabaseSession;
import org.bimserver.database.OldQuery;
import org.bimserver.database.actions.GetAllDatabaseAction;
import org.bimserver.database.query.conditions.IsOfTypeCondition;
import org.bimserver.models.log.AccessMethod;
import org.bimserver.models.store.ObjectIDMPluginConfiguration;
import org.bimserver.models.store.StorePackage;
import org.bimserver.shared.exceptions.UserException;
import org.bimserver.utils.CollectionUtils;

public class GetAllObjectIDMsDatabaseAction
extends GetAllDatabaseAction<ObjectIDMPluginConfiguration> {
    private boolean onlyEnabled;
    private BimServer bimServer;

    public GetAllObjectIDMsDatabaseAction(DatabaseSession databaseSession, AccessMethod accessMethod, BimServer bimServer, boolean onlyEnabled) {
        super(databaseSession, accessMethod, ObjectIDMPluginConfiguration.class, StorePackage.eINSTANCE.getObjectIDMPluginConfiguration());
        this.bimServer = bimServer;
        this.onlyEnabled = onlyEnabled;
    }

    @Override
    public List<ObjectIDMPluginConfiguration> execute() throws UserException, BimserverLockConflictException, BimserverDatabaseException {
        IsOfTypeCondition condition = new IsOfTypeCondition(StorePackage.eINSTANCE.getObjectIDMPluginConfiguration());
        Map<Long, ObjectIDMPluginConfiguration> result = this.getDatabaseSession().query(condition, ObjectIDMPluginConfiguration.class, OldQuery.getDefault());
        List mapToList = CollectionUtils.mapToList(result);
        if (this.onlyEnabled) {
            Iterator iterator = mapToList.iterator();
            while (iterator.hasNext()) {
                ObjectIDMPluginConfiguration objectIdm = (ObjectIDMPluginConfiguration)iterator.next();
                if (this.bimServer.getPluginManager().isEnabled(objectIdm.getPluginDescriptor().getPluginClassName()) && objectIdm.getEnabled().booleanValue()) continue;
                iterator.remove();
            }
        }
        return mapToList;
    }
}

