/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.database.actions;

import java.util.ArrayList;
import java.util.List;
import org.bimserver.BimServer;
import org.bimserver.BimserverDatabaseException;
import org.bimserver.database.BimserverLockConflictException;
import org.bimserver.database.DatabaseSession;
import org.bimserver.database.OldQuery;
import org.bimserver.database.actions.BimDatabaseAction;
import org.bimserver.emf.PackageMetaData;
import org.bimserver.models.log.AccessMethod;
import org.bimserver.models.store.Revision;
import org.bimserver.shared.exceptions.UserException;

public class GetAvailableClassesInRevisionDatabaseAction
extends BimDatabaseAction<List<String>> {
    private final long roid;
    private BimServer bimServer;

    public GetAvailableClassesInRevisionDatabaseAction(BimServer bimServer, DatabaseSession databaseSession, AccessMethod accessMethod, long roid) {
        super(databaseSession, accessMethod);
        this.bimServer = bimServer;
        this.roid = roid;
    }

    @Override
    public List<String> execute() throws UserException, BimserverLockConflictException, BimserverDatabaseException {
        Revision revision = this.getRevisionByRoid(this.roid);
        PackageMetaData packageMetaData = this.bimServer.getMetaDataManager().getPackageMetaData(revision.getProject().getSchema());
        return new ArrayList<String>(this.getDatabaseSession().getAvailableClassesInRevision(new OldQuery(packageMetaData, revision.getProject().getId(), revision.getId(), -1L)));
    }
}

