/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.database.actions;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.bimserver.BimServer;
import org.bimserver.BimserverDatabaseException;
import org.bimserver.database.BimserverLockConflictException;
import org.bimserver.database.DatabaseSession;
import org.bimserver.database.actions.PluginBundleDatabaseAction;
import org.bimserver.interfaces.objects.SPluginBundle;
import org.bimserver.models.log.AccessMethod;
import org.bimserver.plugins.GitHubPluginRepository;
import org.bimserver.plugins.PluginBundle;
import org.bimserver.plugins.PluginLocation;
import org.bimserver.shared.exceptions.ServerException;
import org.bimserver.shared.exceptions.UserException;

public class GetAvailablePluginBundles
extends PluginBundleDatabaseAction<List<SPluginBundle>> {
    private BimServer bimServer;
    private boolean strictVersionChecking;
    private DefaultArtifactVersion bimserverVersion;

    public GetAvailablePluginBundles(DatabaseSession databaseSession, AccessMethod accessMethod, BimServer bimServer, boolean strictVersionChecking) {
        super(databaseSession, accessMethod);
        this.bimServer = bimServer;
        this.strictVersionChecking = strictVersionChecking;
    }

    @Override
    public List<SPluginBundle> execute() throws UserException, BimserverLockConflictException, BimserverDatabaseException, ServerException {
        final ArrayList<SPluginBundle> result = new ArrayList<SPluginBundle>();
        GitHubPluginRepository repository = new GitHubPluginRepository(this.bimServer.getMavenPluginRepository(), this.bimServer.getServerSettingsCache().getServerSettings().getServiceRepositoryUrl());
        this.bimserverVersion = new DefaultArtifactVersion(this.bimServer.getVersionChecker().getLocalVersion().getFullString());
        ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(32, 32, 1L, TimeUnit.HOURS, new ArrayBlockingQueue<Runnable>(100));
        for (final PluginLocation pluginLocation : repository.listPluginLocations()) {
            PluginBundle pluginBundle = this.bimServer.getPluginManager().getPluginBundle(pluginLocation.getPluginIdentifier());
            if (pluginBundle != null) continue;
            threadPoolExecutor.submit(new Runnable(){

                @Override
                public void run() {
                    SPluginBundle sPluginBundle = GetAvailablePluginBundles.this.processPluginLocation(pluginLocation, GetAvailablePluginBundles.this.strictVersionChecking, GetAvailablePluginBundles.this.bimserverVersion);
                    if (sPluginBundle != null) {
                        result.add(sPluginBundle);
                    }
                }
            });
        }
        threadPoolExecutor.shutdown();
        try {
            threadPoolExecutor.awaitTermination(1L, TimeUnit.HOURS);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        Collections.sort(result, new Comparator<SPluginBundle>(){

            @Override
            public int compare(SPluginBundle o1, SPluginBundle o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        return result;
    }
}

