/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.database.actions;

import java.util.HashSet;
import java.util.Set;
import org.bimserver.BimserverDatabaseException;
import org.bimserver.database.BimserverLockConflictException;
import org.bimserver.database.DatabaseSession;
import org.bimserver.database.actions.BimDatabaseAction;
import org.bimserver.database.actions.GetCheckoutWarningsDatabaseAction;
import org.bimserver.models.log.AccessMethod;
import org.bimserver.models.store.Checkout;
import org.bimserver.models.store.Project;
import org.bimserver.models.store.Revision;
import org.bimserver.models.store.User;
import org.bimserver.shared.exceptions.UserException;
import org.bimserver.webservices.authorization.Authorization;

public class GetCheckinWarningsDatabaseAction
extends BimDatabaseAction<Set<String>> {
    private final long poid;
    private Authorization authorization;

    public GetCheckinWarningsDatabaseAction(DatabaseSession databaseSession, AccessMethod accessMethod, long poid, Authorization authorization) {
        super(databaseSession, accessMethod);
        this.poid = poid;
        this.authorization = authorization;
    }

    @Override
    public Set<String> execute() throws UserException, BimserverLockConflictException, BimserverDatabaseException {
        Project project = this.getProjectByPoid(this.poid);
        User user = this.getUserByUoid(this.authorization.getUoid());
        HashSet<String> warnings = new HashSet<String>();
        this.checkInterleavingCommits(project, user, warnings);
        new GetCheckoutWarningsDatabaseAction(this.getDatabaseSession(), this.getAccessMethod(), this.poid, this.authorization).checkOtherUsersCheckouts(project, user, warnings);
        return warnings;
    }

    private void checkInterleavingCommits(Project project, User user, Set<String> warnings) {
        Checkout lastOwnActiveCheckout = null;
        for (Checkout checkout : project.getCheckouts()) {
            if (checkout.getUser() != user || !checkout.getActive().booleanValue()) continue;
            lastOwnActiveCheckout = checkout;
        }
        if (lastOwnActiveCheckout != null) {
            Project mainProject = project;
            while (mainProject.getParent() != null) {
                mainProject = mainProject.getParent();
            }
            int newRevisionsAfterCheckout = 0;
            for (Revision virtualRevision : mainProject.getRevisions()) {
                if (!lastOwnActiveCheckout.getDate().before(virtualRevision.getDate()) || lastOwnActiveCheckout.getRevision() == virtualRevision) continue;
                ++newRevisionsAfterCheckout;
            }
            if (newRevisionsAfterCheckout == 1) {
                warnings.add("Warning, after your last checkout of this project (revision " + lastOwnActiveCheckout.getRevision().getId() + "), a new revision has been checked-in");
            } else if (newRevisionsAfterCheckout > 1) {
                warnings.add("Warning, after your last checkout of this project (revision " + lastOwnActiveCheckout.getRevision().getId() + "), " + newRevisionsAfterCheckout + " new revisions have been checked-in");
            }
        }
    }
}

