/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.database.actions;

import org.bimserver.BimserverDatabaseException;
import org.bimserver.database.BimserverLockConflictException;
import org.bimserver.database.DatabaseSession;
import org.bimserver.database.OldQuery;
import org.bimserver.database.actions.BimDatabaseAction;
import org.bimserver.emf.QueryInterface;
import org.bimserver.models.log.AccessMethod;
import org.bimserver.models.store.GeoTag;
import org.bimserver.models.store.Project;
import org.bimserver.models.store.StorePackage;
import org.bimserver.models.store.User;
import org.bimserver.shared.exceptions.UserException;
import org.bimserver.webservices.authorization.Authorization;

public class GetGeoTagDatabaseAction
extends BimDatabaseAction<GeoTag> {
    private final long goid;
    private Authorization authorization;

    public GetGeoTagDatabaseAction(DatabaseSession databaseSession, AccessMethod accessMethod, Authorization authorization, long goid) {
        super(databaseSession, accessMethod);
        this.authorization = authorization;
        this.goid = goid;
    }

    @Override
    public GeoTag execute() throws UserException, BimserverLockConflictException, BimserverDatabaseException {
        User actingUser = this.getUserByUoid(this.authorization.getUoid());
        GeoTag geoTag = (GeoTag)this.getDatabaseSession().get(StorePackage.eINSTANCE.getGeoTag(), this.goid, (QueryInterface)OldQuery.getDefault());
        boolean hasRights = false;
        for (Project project : geoTag.getProjects()) {
            if (!this.authorization.hasRightsOnProject(actingUser, project)) continue;
            hasRights = true;
        }
        if (hasRights) {
            return geoTag;
        }
        throw new UserException("User has no rights on any projects associated with this geotag");
    }
}

