/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.database.actions;

import org.bimserver.BimServer;
import org.bimserver.BimserverDatabaseException;
import org.bimserver.database.BimserverLockConflictException;
import org.bimserver.database.DatabaseSession;
import org.bimserver.database.OldQuery;
import org.bimserver.database.actions.BimDatabaseAction;
import org.bimserver.emf.PackageMetaData;
import org.bimserver.interfaces.objects.SGeometryInfo;
import org.bimserver.models.geometry.GeometryInfo;
import org.bimserver.models.log.AccessMethod;
import org.bimserver.models.store.Project;
import org.bimserver.models.store.Revision;
import org.bimserver.shared.exceptions.UserException;
import org.bimserver.webservices.authorization.Authorization;
import org.eclipse.emf.ecore.EStructuralFeature;

public class GetGeometryInfoDatabaseAction
extends BimDatabaseAction<SGeometryInfo> {
    private BimServer bimServer;
    private long roid;
    private long oid;

    public GetGeometryInfoDatabaseAction(BimServer bimServer, DatabaseSession databaseSession, AccessMethod accessMethod, long roid, long oid, Authorization authorization) {
        super(databaseSession, accessMethod);
        this.bimServer = bimServer;
        this.roid = roid;
        this.oid = oid;
    }

    @Override
    public SGeometryInfo execute() throws UserException, BimserverDatabaseException, BimserverLockConflictException {
        Revision revision = (Revision)this.getDatabaseSession().get(this.roid, OldQuery.getDefault());
        Project project = revision.getProject();
        PackageMetaData packageMetaData = this.bimServer.getMetaDataManager().getPackageMetaData(project.getSchema());
        Object ifcProduct = this.getDatabaseSession().get(this.oid, new OldQuery(packageMetaData, project.getId(), revision.getId(), revision.getOid()));
        if (ifcProduct == null) {
            throw new UserException("Object with oid " + this.oid + " not found");
        }
        EStructuralFeature geometryFeature = packageMetaData.getEClass("IfcProduct").getEStructuralFeature("geometry");
        GeometryInfo geometry = (GeometryInfo)ifcProduct.eGet(geometryFeature);
        SGeometryInfo convertToSObject = this.bimServer.getSConverter().convertToSObject(geometry);
        return convertToSObject;
    }
}

