/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.database.actions;

import org.bimserver.BimServer;
import org.bimserver.BimserverDatabaseException;
import org.bimserver.database.BimserverLockConflictException;
import org.bimserver.database.DatabaseSession;
import org.bimserver.database.OldQuery;
import org.bimserver.database.actions.BimDatabaseAction;
import org.bimserver.interfaces.objects.SIfcHeader;
import org.bimserver.models.log.AccessMethod;
import org.bimserver.models.store.ConcreteRevision;
import org.bimserver.shared.exceptions.UserException;
import org.bimserver.webservices.authorization.Authorization;

public class GetIfcHeaderDatabaseAction
extends BimDatabaseAction<SIfcHeader> {
    private long croid;
    private BimServer bimServer;

    public GetIfcHeaderDatabaseAction(BimServer bimServer, DatabaseSession databaseSession, AccessMethod accessMethod, long croid, Authorization authorization) {
        super(databaseSession, accessMethod);
        this.bimServer = bimServer;
        this.croid = croid;
    }

    @Override
    public SIfcHeader execute() throws UserException, BimserverDatabaseException, BimserverLockConflictException {
        ConcreteRevision concreteRevision = (ConcreteRevision)this.getDatabaseSession().get(this.croid, OldQuery.getDefault());
        if (concreteRevision == null) {
            throw new UserException("No ConcreteRevision found with oid " + this.croid);
        }
        return this.bimServer.getSConverter().convertToSObject(concreteRevision.getIfcHeader());
    }
}

