/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.database.actions;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.bimserver.BimServer;
import org.bimserver.BimserverDatabaseException;
import org.bimserver.database.BimserverLockConflictException;
import org.bimserver.database.DatabaseSession;
import org.bimserver.database.actions.GetInstalledPluginBundle;
import org.bimserver.database.actions.PluginBundleDatabaseAction;
import org.bimserver.interfaces.objects.SPluginBundle;
import org.bimserver.interfaces.objects.SPluginBundleVersion;
import org.bimserver.models.log.AccessMethod;
import org.bimserver.plugins.GitHubPluginRepository;
import org.bimserver.plugins.PluginBundle;
import org.bimserver.plugins.PluginBundleIdentifier;
import org.bimserver.plugins.PluginLocation;
import org.bimserver.shared.exceptions.ServerException;
import org.bimserver.shared.exceptions.UserException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetInstalledPluginBundles
extends PluginBundleDatabaseAction<List<SPluginBundle>> {
    private static final Logger LOGGER = LoggerFactory.getLogger(GetInstalledPluginBundle.class);
    private BimServer bimServer;
    private boolean strictVersionChecking;
    private DefaultArtifactVersion bimserverVersion;

    public GetInstalledPluginBundles(DatabaseSession databaseSession, AccessMethod accessMethod, BimServer bimServer, boolean strictVersionChecking) {
        super(databaseSession, accessMethod);
        this.bimServer = bimServer;
        this.strictVersionChecking = strictVersionChecking;
    }

    @Override
    public List<SPluginBundle> execute() throws UserException, BimserverLockConflictException, BimserverDatabaseException, ServerException {
        final ArrayList<SPluginBundle> result = new ArrayList<SPluginBundle>();
        this.bimserverVersion = new DefaultArtifactVersion(this.bimServer.getVersionChecker().getLocalVersion().getFullString());
        GitHubPluginRepository repository = new GitHubPluginRepository(this.bimServer.getMavenPluginRepository(), this.bimServer.getServerSettingsCache().getServerSettings().getServiceRepositoryUrl());
        HashMap<PluginBundleIdentifier, PluginLocation> repositoryKnownLocation = new HashMap<PluginBundleIdentifier, PluginLocation>();
        for (Object pluginLocation : repository.listPluginLocations()) {
            repositoryKnownLocation.put(pluginLocation.getPluginIdentifier(), (PluginLocation)pluginLocation);
        }
        ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(32, 32, 1L, TimeUnit.HOURS, new ArrayBlockingQueue<Runnable>(100));
        for (final PluginBundle pluginBundle : this.bimServer.getPluginManager().getPluginBundles()) {
            final SPluginBundleVersion installedVersion = pluginBundle.getPluginBundleVersion();
            PluginBundleIdentifier pluginBundleIdentifier = new PluginBundleIdentifier(installedVersion.getGroupId(), installedVersion.getArtifactId());
            final PluginLocation pluginLocation = (PluginLocation)repositoryKnownLocation.get(pluginBundleIdentifier);
            threadPoolExecutor.submit(new Runnable(){

                @Override
                public void run() {
                    SPluginBundle sPluginBundle = GetInstalledPluginBundles.this.processPluginLocation(pluginLocation, GetInstalledPluginBundles.this.strictVersionChecking, GetInstalledPluginBundles.this.bimserverVersion);
                    if (sPluginBundle == null) {
                        sPluginBundle = pluginBundle.getPluginBundle();
                    }
                    boolean found = false;
                    for (SPluginBundleVersion sPluginBundleVersion : sPluginBundle.getAvailableVersions()) {
                        if (!sPluginBundleVersion.getVersion().equals(pluginBundle.getPluginBundleVersion().getVersion())) continue;
                        found = true;
                    }
                    if (!found) {
                        sPluginBundle.getAvailableVersions().add(pluginBundle.getPluginBundleVersion());
                    }
                    sPluginBundle.setInstalledVersion(installedVersion);
                    result.add(sPluginBundle);
                }
            });
        }
        threadPoolExecutor.shutdown();
        try {
            threadPoolExecutor.awaitTermination(1L, TimeUnit.HOURS);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        Collections.sort(result, new Comparator<SPluginBundle>(){

            @Override
            public int compare(SPluginBundle o1, SPluginBundle o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        return result;
    }
}

