/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.database.actions;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.bimserver.BimserverDatabaseException;
import org.bimserver.database.BimserverLockConflictException;
import org.bimserver.database.DatabaseSession;
import org.bimserver.database.OldQuery;
import org.bimserver.database.actions.BimDatabaseAction;
import org.bimserver.database.query.conditions.IsOfTypeCondition;
import org.bimserver.models.log.AccessMethod;
import org.bimserver.models.log.LogAction;
import org.bimserver.models.log.LogPackage;
import org.bimserver.models.store.User;
import org.bimserver.models.store.UserType;
import org.bimserver.shared.exceptions.UserException;
import org.bimserver.webservices.authorization.Authorization;

public class GetLogsDatabaseAction
extends BimDatabaseAction<List<LogAction>> {
    private Authorization authorization;

    public GetLogsDatabaseAction(DatabaseSession databaseSession, AccessMethod accessMethod, Authorization authorization) {
        super(databaseSession, accessMethod);
        this.authorization = authorization;
    }

    @Override
    public List<LogAction> execute() throws UserException, BimserverLockConflictException, BimserverDatabaseException {
        User user = this.getUserByUoid(this.authorization.getUoid());
        if (user.getUserType() != UserType.ADMIN) {
            throw new UserException("Only admin users can retrieve log");
        }
        Map<Long, LogAction> query = this.getDatabaseSession().query(new IsOfTypeCondition(LogPackage.eINSTANCE.getLogAction()), LogAction.class, OldQuery.getDefault());
        ArrayList<LogAction> list = new ArrayList<LogAction>(query.values());
        return list;
    }
}

