/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.database.actions;

import org.bimserver.BimserverDatabaseException;
import org.bimserver.database.BimserverLockConflictException;
import org.bimserver.database.DatabaseSession;
import org.bimserver.database.ObjectIdentifier;
import org.bimserver.database.actions.BimDatabaseAction;
import org.bimserver.models.log.AccessMethod;
import org.bimserver.models.store.ConcreteRevision;
import org.bimserver.models.store.Revision;
import org.bimserver.shared.exceptions.UserException;

public class GetOidByGuidDatabaseAction
extends BimDatabaseAction<Long> {
    private final String guid;
    private final long roid;

    public GetOidByGuidDatabaseAction(DatabaseSession databaseSession, AccessMethod accessMethod, long roid, String guid) {
        super(databaseSession, accessMethod);
        this.roid = roid;
        this.guid = guid;
    }

    @Override
    public Long execute() throws UserException, BimserverLockConflictException, BimserverDatabaseException {
        Revision virtualRevision = this.getRevisionByRoid(this.roid);
        ObjectIdentifier objectIdentifier = null;
        for (ConcreteRevision concreteRevision : virtualRevision.getConcreteRevisions()) {
            long oidOfGuid;
            objectIdentifier = this.getDatabaseSession().getOidOfGuid(concreteRevision.getProject().getSchema(), this.guid, concreteRevision.getProject().getId(), concreteRevision.getId());
            if (objectIdentifier == null || (oidOfGuid = objectIdentifier.getOid()) == -1L) continue;
            break;
        }
        if (objectIdentifier == null) {
            throw new UserException("Guid " + this.guid + " not found in this revision/project");
        }
        return objectIdentifier.getOid();
    }
}

