/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.database.actions;

import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.bimserver.BimServer;
import org.bimserver.BimserverDatabaseException;
import org.bimserver.database.BimserverLockConflictException;
import org.bimserver.database.DatabaseSession;
import org.bimserver.database.actions.PluginBundleDatabaseAction;
import org.bimserver.interfaces.objects.SPluginBundle;
import org.bimserver.models.log.AccessMethod;
import org.bimserver.plugins.MavenPluginLocation;
import org.bimserver.plugins.PluginBundle;
import org.bimserver.plugins.PluginLocation;
import org.bimserver.shared.exceptions.ServerException;
import org.bimserver.shared.exceptions.UserException;

public class GetPluginBundle
extends PluginBundleDatabaseAction<SPluginBundle> {
    private BimServer bimServer;
    private DefaultArtifactVersion bimserverVersion;
    private String repository;
    private String groupId;
    private String artifactId;

    public GetPluginBundle(DatabaseSession databaseSession, AccessMethod accessMethod, BimServer bimServer, String repository, String groupId, String artifactId) {
        super(databaseSession, accessMethod);
        this.bimServer = bimServer;
        this.repository = repository;
        this.groupId = groupId;
        this.artifactId = artifactId;
    }

    @Override
    public SPluginBundle execute() throws UserException, BimserverLockConflictException, BimserverDatabaseException, ServerException {
        SPluginBundle sPluginBundle;
        if (this.bimServer.getVersionChecker() != null && this.bimServer.getVersionChecker().getLocalVersion() != null) {
            this.bimserverVersion = new DefaultArtifactVersion(this.bimServer.getVersionChecker().getLocalVersion().getFullString());
        }
        MavenPluginLocation pluginLocation = this.bimServer.getMavenPluginRepository().getPluginLocation(this.repository, this.groupId, this.artifactId);
        PluginBundle pluginBundle = this.bimServer.getPluginManager().getPluginBundle(pluginLocation.getPluginIdentifier());
        if (pluginBundle == null && (sPluginBundle = this.processPluginLocation((PluginLocation<?>)pluginLocation, false, this.bimserverVersion)) != null) {
            return sPluginBundle;
        }
        throw new UserException("Plugin bundle already installed " + this.groupId + "." + this.artifactId);
    }
}

