/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.database.actions;

import java.util.Comparator;
import java.util.Map;
import java.util.TreeMap;
import org.bimserver.BimserverDatabaseException;
import org.bimserver.database.BimserverLockConflictException;
import org.bimserver.database.DatabaseSession;
import org.bimserver.database.actions.BimDatabaseAction;
import org.bimserver.models.ifc2x3tc1.Ifc2x3tc1Package;
import org.bimserver.models.log.AccessMethod;
import org.bimserver.models.store.ConcreteRevision;
import org.bimserver.models.store.Revision;
import org.bimserver.models.store.RevisionSummary;
import org.bimserver.models.store.RevisionSummaryContainer;
import org.bimserver.models.store.RevisionSummaryType;
import org.bimserver.models.store.StoreFactory;
import org.bimserver.shared.exceptions.UserException;
import org.eclipse.emf.ecore.EClass;

public class GetRevisionSummaryDatabaseAction
extends BimDatabaseAction<RevisionSummary> {
    private final long roid;
    private RevisionSummaryContainer revisionSummaryContainerEntities;
    private RevisionSummaryContainer revisionSummaryContainerRelations;
    private RevisionSummaryContainer revisionSummaryContainerPrimitives;
    private RevisionSummaryContainer revisionSummaryContainerOther;
    private Map<EClass, Integer> map = new TreeMap<EClass, Integer>(new Comparator<EClass>(){

        @Override
        public int compare(EClass o1, EClass o2) {
            return o1.getName().compareTo(o2.getName());
        }
    });

    public GetRevisionSummaryDatabaseAction(DatabaseSession databaseSession, AccessMethod accessMethod, long roid) {
        super(databaseSession, accessMethod);
        this.roid = roid;
    }

    @Override
    public RevisionSummary execute() throws UserException, BimserverLockConflictException, BimserverDatabaseException {
        Revision revision = this.getRevisionByRoid(this.roid);
        if (revision.getConcreteRevisions().size() == 1 && ((ConcreteRevision)revision.getConcreteRevisions().get(0)).getSummary() != null) {
            return ((ConcreteRevision)revision.getConcreteRevisions().get(0)).getSummary();
        }
        for (ConcreteRevision concreteRevision : revision.getConcreteRevisions()) {
            if (concreteRevision.getSummary() == null) continue;
            this.merge(concreteRevision.getSummary());
        }
        return this.createSummary();
    }

    private RevisionSummary createSummary() {
        RevisionSummary revisionSummary = StoreFactory.eINSTANCE.createRevisionSummary();
        this.revisionSummaryContainerEntities = StoreFactory.eINSTANCE.createRevisionSummaryContainer();
        this.revisionSummaryContainerEntities.setName("IFC Entities");
        revisionSummary.getList().add((Object)this.revisionSummaryContainerEntities);
        this.revisionSummaryContainerRelations = StoreFactory.eINSTANCE.createRevisionSummaryContainer();
        this.revisionSummaryContainerRelations.setName("IFC Relations");
        revisionSummary.getList().add((Object)this.revisionSummaryContainerRelations);
        this.revisionSummaryContainerPrimitives = StoreFactory.eINSTANCE.createRevisionSummaryContainer();
        this.revisionSummaryContainerPrimitives.setName("IFC Primitives");
        revisionSummary.getList().add((Object)this.revisionSummaryContainerPrimitives);
        this.revisionSummaryContainerOther = StoreFactory.eINSTANCE.createRevisionSummaryContainer();
        this.revisionSummaryContainerOther.setName("Rest");
        revisionSummary.getList().add((Object)this.revisionSummaryContainerOther);
        for (EClass eClass : this.map.keySet()) {
            RevisionSummaryContainer subMap = null;
            subMap = Ifc2x3tc1Package.eINSTANCE.getIfcObject().isSuperTypeOf(eClass) ? this.revisionSummaryContainerEntities : (Ifc2x3tc1Package.eINSTANCE.getIfcRelationship().isSuperTypeOf(eClass) ? this.revisionSummaryContainerRelations : (eClass.getEAnnotation("wrapped") != null ? this.revisionSummaryContainerPrimitives : this.revisionSummaryContainerOther));
            RevisionSummaryType createRevisionSummaryType = StoreFactory.eINSTANCE.createRevisionSummaryType();
            createRevisionSummaryType.setSchema(eClass.getEPackage().getName());
            createRevisionSummaryType.setCount(this.map.get(eClass));
            createRevisionSummaryType.setName(eClass.getName());
            subMap.getTypes().add((Object)createRevisionSummaryType);
        }
        return revisionSummary;
    }

    private void merge(RevisionSummary add) throws BimserverDatabaseException {
        for (RevisionSummaryContainer summaryContainer : add.getList()) {
            for (RevisionSummaryType revisionSummaryType : summaryContainer.getTypes()) {
                if (!this.map.containsKey(this.getDatabaseSession().getEClass(revisionSummaryType.getSchema(), revisionSummaryType.getName()))) {
                    this.map.put(this.getDatabaseSession().getEClass(revisionSummaryType.getSchema(), revisionSummaryType.getName()), revisionSummaryType.getCount());
                    continue;
                }
                this.map.put(this.getDatabaseSession().getEClass(revisionSummaryType.getSchema(), revisionSummaryType.getName()), this.map.get(this.getDatabaseSession().getEClass(revisionSummaryType.getSchema(), revisionSummaryType.getName())) + revisionSummaryType.getCount());
            }
        }
    }
}

