/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.database.actions;

import java.util.HashSet;
import java.util.Set;
import org.bimserver.BimserverDatabaseException;
import org.bimserver.database.BimserverLockConflictException;
import org.bimserver.database.DatabaseSession;
import org.bimserver.database.actions.BimDatabaseAction;
import org.bimserver.models.log.AccessMethod;
import org.bimserver.models.store.ObjectState;
import org.bimserver.models.store.Project;
import org.bimserver.models.store.User;
import org.bimserver.shared.exceptions.UserException;
import org.bimserver.webservices.authorization.AdminAuthorization;
import org.bimserver.webservices.authorization.Authorization;

public class GetSubProjectsDatabaseAction
extends BimDatabaseAction<Set<Project>> {
    private final long poid;
    private Authorization authorization;

    public GetSubProjectsDatabaseAction(DatabaseSession databaseSession, AccessMethod accessMethod, Authorization authorization, long poid) {
        super(databaseSession, accessMethod);
        this.authorization = authorization;
        this.poid = poid;
    }

    @Override
    public Set<Project> execute() throws UserException, BimserverLockConflictException, BimserverDatabaseException {
        Project project;
        User user = this.getUserByUoid(this.authorization.getUoid());
        if (!this.authorization.hasRightsOnProjectOrSuperProjectsOrSubProjects(user, project = this.getProjectByPoid(this.poid))) {
            throw new UserException("User has no rights on project");
        }
        HashSet<Project> subProjects = new HashSet<Project>();
        for (Project subProject : project.getSubProjects()) {
            if (subProject.getState() != ObjectState.ACTIVE && !(this.authorization instanceof AdminAuthorization)) continue;
            subProjects.add(subProject);
        }
        return subProjects;
    }
}

