/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.database.actions;

import java.util.List;
import org.bimserver.BimServer;
import org.bimserver.BimserverDatabaseException;
import org.bimserver.database.BimserverLockConflictException;
import org.bimserver.database.DatabaseSession;
import org.bimserver.database.actions.BimDatabaseAction;
import org.bimserver.interfaces.objects.SPluginInformation;
import org.bimserver.models.log.AccessMethod;
import org.bimserver.plugins.MavenPluginBundle;
import org.bimserver.plugins.MavenPluginLocation;
import org.bimserver.shared.exceptions.ServerException;
import org.bimserver.shared.exceptions.UserException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InstallPluginBundle
extends BimDatabaseAction<Void> {
    private static final Logger LOGGER = LoggerFactory.getLogger(InstallPluginBundle.class);
    private BimServer bimServer;
    private String groupId;
    private String artifactId;
    private String version;
    private String repository;
    private List<SPluginInformation> plugins;

    public InstallPluginBundle(DatabaseSession databaseSession, AccessMethod accessMethod, BimServer bimServer, String repository, String groupId, String artifactId, String version, List<SPluginInformation> plugins) {
        super(databaseSession, accessMethod);
        this.bimServer = bimServer;
        this.repository = repository;
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.version = version;
        this.plugins = plugins;
    }

    @Override
    public Void execute() throws UserException, BimserverLockConflictException, BimserverDatabaseException, ServerException {
        LOGGER.info("Installing plugin " + this.repository + " " + this.groupId + "." + this.artifactId + "." + this.version);
        MavenPluginLocation mavenPluginLocation = this.bimServer.getMavenPluginRepository().getPluginLocation(this.repository, this.groupId, this.artifactId);
        if (this.version == null) {
            String latestVersion = mavenPluginLocation.getLatestVersionString();
            LOGGER.info("Using version " + latestVersion + " because no version given");
            this.version = latestVersion;
        }
        try {
            LOGGER.info(mavenPluginLocation.getRepository(this.version));
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        MavenPluginBundle mavenPluginBundle = mavenPluginLocation.getMavenPluginBundle(this.version);
        LOGGER.info(mavenPluginBundle.getVersion());
        try {
            this.bimServer.getPluginManager().install(mavenPluginBundle, this.plugins, false);
        }
        catch (Exception e) {
            LOGGER.error("", (Throwable)e);
            throw new UserException((Throwable)e);
        }
        return null;
    }
}

