/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.database.actions;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.List;
import org.bimserver.BimServer;
import org.bimserver.BimserverDatabaseException;
import org.bimserver.database.BimserverLockConflictException;
import org.bimserver.database.DatabaseSession;
import org.bimserver.database.actions.BimDatabaseAction;
import org.bimserver.interfaces.objects.SPluginInformation;
import org.bimserver.models.log.AccessMethod;
import org.bimserver.plugins.LocalMavenPluginBundle;
import org.bimserver.plugins.MavenPluginBundle;
import org.bimserver.shared.exceptions.ServerException;
import org.bimserver.shared.exceptions.UserException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InstallPluginBundleFromBytes
extends BimDatabaseAction<Void> {
    private static final Logger LOGGER = LoggerFactory.getLogger(InstallPluginBundleFromBytes.class);
    private BimServer bimServer;
    private byte[] data;
    private Boolean installAllPluginsForAllUsers;
    private Boolean installAllPluginsForNewUsers;

    public InstallPluginBundleFromBytes(DatabaseSession databaseSession, AccessMethod accessMethod, BimServer bimServer, byte[] data, Boolean installAllPluginsForAllUsers, Boolean installAllPluginsForNewUsers) {
        super(databaseSession, accessMethod);
        this.bimServer = bimServer;
        this.data = data;
        this.installAllPluginsForAllUsers = installAllPluginsForAllUsers;
        this.installAllPluginsForNewUsers = installAllPluginsForNewUsers;
    }

    @Override
    public Void execute() throws UserException, BimserverLockConflictException, BimserverDatabaseException, ServerException {
        LocalMavenPluginBundle mavenPluginBundle = new LocalMavenPluginBundle(this.data);
        try {
            List pluginInformationFromPluginFile = this.bimServer.getPluginManager().getPluginInformationFromJar((InputStream)new ByteArrayInputStream(this.data));
            for (SPluginInformation sPluginInformation : pluginInformationFromPluginFile) {
                sPluginInformation.setEnabled(true);
                if (this.installAllPluginsForAllUsers.booleanValue()) {
                    sPluginInformation.setInstallForAllUsers(true);
                }
                if (!this.installAllPluginsForNewUsers.booleanValue()) continue;
                sPluginInformation.setInstallForNewUsers(true);
            }
            this.bimServer.getPluginManager().install((MavenPluginBundle)mavenPluginBundle, pluginInformationFromPluginFile, false);
        }
        catch (Exception e) {
            LOGGER.error("", (Throwable)e);
            throw new UserException((Throwable)e);
        }
        return null;
    }
}

