/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.database.actions;

import java.security.SecureRandom;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import org.bimserver.BimServer;
import org.bimserver.BimserverDatabaseException;
import org.bimserver.database.BimserverLockConflictException;
import org.bimserver.database.DatabaseSession;
import org.bimserver.database.actions.BimDatabaseAction;
import org.bimserver.database.actions.GetUserByUserTokenDatabaseAction;
import org.bimserver.emf.IdEObject;
import org.bimserver.models.log.AccessMethod;
import org.bimserver.models.store.ObjectState;
import org.bimserver.models.store.User;
import org.bimserver.models.store.UserType;
import org.bimserver.shared.exceptions.ServerException;
import org.bimserver.shared.exceptions.UserException;
import org.bimserver.webservices.ServiceMap;
import org.bimserver.webservices.authorization.AdminAuthorization;
import org.bimserver.webservices.authorization.Authorization;
import org.bimserver.webservices.authorization.UserAuthorization;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoginUserTokenDatabaseAction
extends BimDatabaseAction<String> {
    private static final Logger LOGGER = LoggerFactory.getLogger(LoginUserTokenDatabaseAction.class);
    public static final Integer DEFAULT_LOGIN_ERROR_TIMEOUT = 2000;
    private BimServer bimServer;
    private ServiceMap serviceMap;
    private String userToken;

    public LoginUserTokenDatabaseAction(BimServer bimServer, DatabaseSession databaseSession, ServiceMap serviceMap, AccessMethod accessMethod, String userToken) {
        super(databaseSession, accessMethod);
        this.bimServer = bimServer;
        this.serviceMap = serviceMap;
        this.userToken = userToken;
    }

    @Override
    public String execute() throws UserException, BimserverLockConflictException, BimserverDatabaseException, ServerException {
        GetUserByUserTokenDatabaseAction action = new GetUserByUserTokenDatabaseAction(this.getDatabaseSession(), this.getAccessMethod(), this.userToken);
        User user = (User)((BimDatabaseAction)action).execute();
        if (user != null) {
            if (user.getState() == ObjectState.DELETED) {
                throw new UserException("User account has been deleted");
            }
            if (user.getUserType() == UserType.SYSTEM) {
                throw new UserException("System user cannot login");
            }
            Authorization authorization = null;
            authorization = user.getUserType() == UserType.ADMIN ? new AdminAuthorization(this.bimServer.getServerSettingsCache().getServerSettings().getSessionTimeOutSeconds(), TimeUnit.SECONDS) : new UserAuthorization(this.bimServer.getServerSettingsCache().getServerSettings().getSessionTimeOutSeconds(), TimeUnit.SECONDS);
            authorization.setUoid(user.getOid());
            String asHexToken = authorization.asHexToken(this.bimServer.getEncryptionKey());
            this.serviceMap.setAuthorization(authorization);
            if (this.bimServer.getServerSettingsCache().getServerSettings().isStoreLastLogin()) {
                user.setLastSeen(new Date());
                this.getDatabaseSession().store((IdEObject)user);
            }
            return asHexToken;
        }
        try {
            Thread.sleep(DEFAULT_LOGIN_ERROR_TIMEOUT + new SecureRandom().nextInt(1000));
        }
        catch (InterruptedException e) {
            LOGGER.error("", (Throwable)e);
        }
        throw new UserException("Invalid token");
    }
}

