/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.database.actions;

import java.io.IOException;
import java.util.GregorianCalendar;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.apache.maven.artifact.versioning.VersionRange;
import org.bimserver.database.DatabaseSession;
import org.bimserver.database.actions.BimDatabaseAction;
import org.bimserver.interfaces.objects.SPluginBundle;
import org.bimserver.interfaces.objects.SPluginBundleType;
import org.bimserver.interfaces.objects.SPluginBundleVersion;
import org.bimserver.models.log.AccessMethod;
import org.bimserver.plugins.MavenDependency;
import org.bimserver.plugins.MavenPluginLocation;
import org.bimserver.plugins.MavenPluginVersion;
import org.bimserver.plugins.PluginLocation;
import org.bimserver.plugins.PluginVersion;
import org.eclipse.aether.resolution.ArtifactResolutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PluginBundleDatabaseAction<T>
extends BimDatabaseAction<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(PluginBundleDatabaseAction.class);

    public PluginBundleDatabaseAction(DatabaseSession databaseSession, AccessMethod accessMethod) {
        super(databaseSession, accessMethod);
    }

    public SPluginBundle processPluginLocation(PluginLocation<?> pluginLocation, boolean strictVersionChecking, DefaultArtifactVersion bimserverVersion) {
        if (pluginLocation instanceof MavenPluginLocation) {
            return this.processMavenPluginLocation((MavenPluginLocation)pluginLocation, strictVersionChecking, (ArtifactVersion)bimserverVersion);
        }
        return null;
    }

    public SPluginBundle processMavenPluginLocation(MavenPluginLocation mavenPluginLocation, boolean strictVersionChecking, ArtifactVersion bimserverVersion) {
        SPluginBundle pluginBundle = new SPluginBundle();
        boolean usefulBundle = false;
        for (PluginVersion pluginVersion : mavenPluginLocation.getAllVersions()) {
            if (!(pluginVersion instanceof MavenPluginVersion)) continue;
            SPluginBundleVersion sPluginBundleVersion = new SPluginBundleVersion();
            boolean useful = true;
            MavenPluginVersion mavenPluginVersion = (MavenPluginVersion)pluginVersion;
            for (MavenDependency mavenDependency : mavenPluginVersion.getDependencies()) {
                String artifactId;
                if (!mavenDependency.getArtifact().getGroupId().equals("org.opensourcebim") || !(artifactId = mavenDependency.getArtifact().getArtifactId()).equals("shared") && !artifactId.equals("pluginbase")) continue;
                VersionRange versionRange = VersionRange.createFromVersion((String)mavenDependency.getArtifact().getVersion());
                if (bimserverVersion != null && versionRange.containsVersion(bimserverVersion)) continue;
                sPluginBundleVersion.setMismatch(true);
                if (!strictVersionChecking) continue;
                useful = false;
                LOGGER.info("Skipping version " + mavenPluginVersion.getArtifact().getVersion() + " or artifact " + mavenPluginVersion.getArtifact().getArtifactId());
            }
            if (!useful) continue;
            usefulBundle = true;
            sPluginBundleVersion.setName(mavenPluginVersion.getModel().getName());
            sPluginBundleVersion.setOrganization(mavenPluginVersion.getModel().getOrganization().getName());
            sPluginBundleVersion.setArtifactId(mavenPluginLocation.getArtifactId());
            sPluginBundleVersion.setGroupId(mavenPluginLocation.getGroupId());
            try {
                sPluginBundleVersion.setRepository(mavenPluginLocation.getRepository(mavenPluginVersion.getVersion().toString()));
            }
            catch (ArtifactResolutionException e) {
                LOGGER.error("", (Throwable)e);
            }
            sPluginBundleVersion.setType(SPluginBundleType.MAVEN);
            sPluginBundleVersion.setVersion(mavenPluginVersion.getVersion().toString());
            sPluginBundleVersion.setDescription(mavenPluginVersion.getModel().getDescription());
            pluginBundle.setName(mavenPluginVersion.getModel().getName());
            pluginBundle.setOrganization(mavenPluginVersion.getModel().getOrganization().getName());
            pluginBundle.setLatestVersion(sPluginBundleVersion);
            pluginBundle.getAvailableVersions().add(sPluginBundleVersion);
            try {
                sPluginBundleVersion.setIcon(mavenPluginLocation.getVersionIcon(mavenPluginVersion.getVersion().toString()));
            }
            catch (ArtifactResolutionException e) {
            }
            catch (IOException e) {
                LOGGER.error("", (Throwable)e);
            }
            try {
                GregorianCalendar date = mavenPluginLocation.getVersionDate(mavenPluginVersion.getVersion().toString());
                if (date == null) continue;
                sPluginBundleVersion.setDate(date.getTime());
            }
            catch (ArtifactResolutionException date) {
            }
            catch (Exception e) {
                LOGGER.error("", (Throwable)e);
            }
        }
        if (usefulBundle) {
            return pluginBundle;
        }
        return null;
    }
}

