/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.database.actions;

import org.bimserver.BimServer;
import org.bimserver.BimserverDatabaseException;
import org.bimserver.GenerateGeometryResult;
import org.bimserver.GeometryGeneratingException;
import org.bimserver.database.BimserverLockConflictException;
import org.bimserver.database.DatabaseSession;
import org.bimserver.database.OldQuery;
import org.bimserver.database.actions.AbstractDownloadDatabaseAction;
import org.bimserver.database.actions.ProgressListener;
import org.bimserver.database.actions.ProjectBasedDatabaseAction;
import org.bimserver.emf.IdEObject;
import org.bimserver.emf.PackageMetaData;
import org.bimserver.geometry.GeometryGenerationReport;
import org.bimserver.geometry.StreamingGeometryGenerator;
import org.bimserver.models.log.AccessMethod;
import org.bimserver.models.store.ConcreteRevision;
import org.bimserver.models.store.Revision;
import org.bimserver.plugins.deserializers.DatabaseInterface;
import org.bimserver.shared.QueryContext;
import org.bimserver.shared.exceptions.ServerException;
import org.bimserver.shared.exceptions.UserException;

public class RegenerateGeometryDatabaseAction
extends ProjectBasedDatabaseAction<Void> {
    private BimServer bimServer;
    private long roid;
    private long uoid;
    private long poid;
    private String renderEngineName;
    private Long eoid;

    public RegenerateGeometryDatabaseAction(BimServer bimServer, DatabaseSession databaseSession, AccessMethod accessMethod, long poid, long roid, long uoid, Long eoid) {
        super(databaseSession, accessMethod);
        this.bimServer = bimServer;
        this.poid = poid;
        this.roid = roid;
        this.uoid = uoid;
        this.eoid = eoid;
    }

    @Override
    public Void execute() throws UserException, BimserverLockConflictException, BimserverDatabaseException, ServerException {
        ProgressListener progressListener = new ProgressListener(){

            @Override
            public void updateProgress(String state, int percentage) {
                RegenerateGeometryDatabaseAction.this.setProgress("Generating geometry...", percentage);
            }
        };
        GeometryGenerationReport report = new GeometryGenerationReport();
        report.setOriginalIfcFileName("rerun");
        report.setOriginalIfcFileSize(-1L);
        report.setOriginalDeserializer("rerun");
        StreamingGeometryGenerator streamingGeometryGenerator = new StreamingGeometryGenerator(this.bimServer, progressListener, this.eoid, report);
        Revision revision = (Revision)this.getDatabaseSession().get(this.roid, OldQuery.getDefault());
        ConcreteRevision concreteRevision = (ConcreteRevision)revision.getConcreteRevisions().get(0);
        PackageMetaData packageMetaData = this.bimServer.getMetaDataManager().getPackageMetaData(revision.getProject().getSchema());
        int highestStopId = AbstractDownloadDatabaseAction.findHighestStopRid(concreteRevision.getProject(), concreteRevision);
        QueryContext queryContext = new QueryContext((DatabaseInterface)this.getDatabaseSession(), packageMetaData, revision.getProject().getId().intValue(), revision.getId().intValue(), this.roid, highestStopId);
        try {
            GenerateGeometryResult generateGeometry = streamingGeometryGenerator.generateGeometry(this.uoid, this.getDatabaseSession(), queryContext);
            for (Revision other : concreteRevision.getRevisions()) {
                other.setHasGeometry(true);
            }
            concreteRevision.setMinBounds(generateGeometry.getMinBoundsAsVector3f());
            concreteRevision.setMaxBounds(generateGeometry.getMaxBoundsAsVector3f());
            this.getDatabaseSession().store((IdEObject)concreteRevision);
            this.renderEngineName = streamingGeometryGenerator.getRenderEngineName();
        }
        catch (GeometryGeneratingException e) {
            e.printStackTrace();
        }
        return null;
    }

    @Override
    public String doneMessage() {
        return "Geometry successfully regenerated using " + this.renderEngineName;
    }

    @Override
    public String getFileName() {
        return "test";
    }

    @Override
    public long getPoid() {
        return this.poid;
    }
}

