/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.database.actions;

import java.util.Date;
import java.util.HashMap;
import javax.mail.Message;
import javax.mail.internet.InternetAddress;
import org.bimserver.BimServer;
import org.bimserver.BimserverDatabaseException;
import org.bimserver.database.BimserverLockConflictException;
import org.bimserver.database.DatabaseSession;
import org.bimserver.database.PostCommitAction;
import org.bimserver.database.actions.BimDatabaseAction;
import org.bimserver.emf.IdEObject;
import org.bimserver.mail.EmailMessage;
import org.bimserver.mail.MailSystem;
import org.bimserver.models.log.AccessMethod;
import org.bimserver.models.store.User;
import org.bimserver.shared.exceptions.UserException;
import org.bimserver.templating.TemplateIdentifier;
import org.bimserver.utils.GeneratorUtils;
import org.bimserver.utils.Hashers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestPasswordChangeDatabaseAction
extends BimDatabaseAction<Void> {
    private static final Logger LOGGER = LoggerFactory.getLogger(RequestPasswordChangeDatabaseAction.class);
    private final BimServer bimServer;
    private final String username;
    private String resetUrl;
    private Boolean includeSiteAddress;

    public RequestPasswordChangeDatabaseAction(DatabaseSession databaseSession, AccessMethod accessMethod, BimServer bimServer, String username, String resetUrl, Boolean includeSiteAddress) {
        super(databaseSession, accessMethod);
        this.bimServer = bimServer;
        this.username = username;
        this.resetUrl = resetUrl;
        this.includeSiteAddress = includeSiteAddress;
    }

    @Override
    public Void execute() throws UserException, BimserverLockConflictException, BimserverDatabaseException {
        final User user = this.getUserByUserName(this.username);
        if (user == null) {
            throw new UserException("User with username \"" + this.username + "\" not found");
        }
        final String token = GeneratorUtils.generateToken();
        user.setValidationToken(Hashers.getSha256Hash((String)token));
        user.setValidationTokenCreated(new Date());
        this.getDatabaseSession().store((IdEObject)user);
        this.getDatabaseSession().addPostCommitAction(new PostCommitAction(){

            @Override
            public void execute() throws UserException {
                if (MailSystem.isValidEmailAddress(user.getUsername())) {
                    EmailMessage message = RequestPasswordChangeDatabaseAction.this.bimServer.getMailSystem().createMessage();
                    String body = null;
                    String subject = null;
                    try {
                        InternetAddress addressFrom = new InternetAddress(RequestPasswordChangeDatabaseAction.this.bimServer.getServerSettingsCache().getServerSettings().getEmailSenderAddress());
                        message.setFrom(addressFrom);
                        InternetAddress[] addressTo = new InternetAddress[]{new InternetAddress(user.getUsername())};
                        message.setRecipients(Message.RecipientType.TO, addressTo);
                        HashMap<String, Object> context = new HashMap<String, Object>();
                        context.put("name", user.getName());
                        context.put("username", user.getUsername());
                        if (RequestPasswordChangeDatabaseAction.this.includeSiteAddress.booleanValue()) {
                            context.put("siteaddress", RequestPasswordChangeDatabaseAction.this.bimServer.getServerSettingsCache().getServerSettings().getSiteAddress());
                        }
                        context.put("validationlink", RequestPasswordChangeDatabaseAction.this.resetUrl + "&username=" + user.getUsername() + "&uoid=" + user.getOid() + "&validationtoken=" + token + (RequestPasswordChangeDatabaseAction.this.includeSiteAddress != false ? "&address=" + RequestPasswordChangeDatabaseAction.this.bimServer.getServerSettingsCache().getServerSettings().getSiteAddress() : ""));
                        body = RequestPasswordChangeDatabaseAction.this.bimServer.getTemplateEngine().process(context, TemplateIdentifier.PASSWORD_RESET_EMAIL_BODY);
                        subject = RequestPasswordChangeDatabaseAction.this.bimServer.getTemplateEngine().process(context, TemplateIdentifier.PASSWORD_RESET_EMAIL_SUBJECT);
                        message.setContent(body, "text/html");
                        message.setSubject(subject.trim());
                        message.send();
                    }
                    catch (Exception e) {
                        LOGGER.error(body);
                        throw new UserException(e.getMessage());
                    }
                }
            }
        });
        return null;
    }
}

