/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.database.actions;

import org.bimserver.BimserverDatabaseException;
import org.bimserver.database.BimserverLockConflictException;
import org.bimserver.database.DatabaseSession;
import org.bimserver.database.actions.BimDatabaseAction;
import org.bimserver.emf.IdEObject;
import org.bimserver.models.log.AccessMethod;
import org.bimserver.models.store.ConcreteRevision;
import org.bimserver.models.store.Project;
import org.bimserver.models.store.Revision;
import org.bimserver.shared.exceptions.UserException;
import org.eclipse.emf.common.util.EList;

public class SetRevisionTagDatabaseAction
extends BimDatabaseAction<String> {
    private final Long roid;
    private final String tag;

    public SetRevisionTagDatabaseAction(DatabaseSession databaseSession, AccessMethod accessMethod, Long roid, String tag) {
        super(databaseSession, accessMethod);
        this.roid = roid;
        this.tag = tag;
    }

    @Override
    public String execute() throws UserException, BimserverLockConflictException, BimserverDatabaseException {
        Revision revision = this.getRevisionByRoid(this.roid);
        String trimmedTag = this.tag.trim();
        Project project = revision.getProject();
        if (project.getParent() != null) {
            throw new UserException("Revision is not contained by a top project.");
        }
        EList projRevs = project.getRevisions();
        revision.setTag(trimmedTag);
        this.getDatabaseSession().store((IdEObject)revision);
        EList concreteRevisions = revision.getConcreteRevisions();
        for (ConcreteRevision cRev : concreteRevisions) {
            EList revisions = cRev.getRevisions();
            for (Revision vRev : revisions) {
                if (projRevs.contains((Object)vRev)) continue;
                vRev.setTag(trimmedTag);
                this.getDatabaseSession().store((IdEObject)vRev);
            }
        }
        return null;
    }
}

