/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.database.actions;

import org.bimserver.BimServer;
import org.bimserver.BimserverDatabaseException;
import org.bimserver.database.BimserverLockConflictException;
import org.bimserver.database.DatabaseSession;
import org.bimserver.database.OldQuery;
import org.bimserver.database.PostCommitAction;
import org.bimserver.database.actions.BimDatabaseAction;
import org.bimserver.database.actions.ServerSettingsSetter;
import org.bimserver.emf.IdEObject;
import org.bimserver.models.log.AccessMethod;
import org.bimserver.models.store.ServerSettings;
import org.bimserver.models.store.StorePackage;
import org.bimserver.shared.exceptions.UserException;

public class SetServerSettingDatabaseAction
extends BimDatabaseAction<Void> {
    private ServerSettingsSetter serverSettingsSetter;
    private BimServer bimServer;

    public SetServerSettingDatabaseAction(BimServer bimServer, DatabaseSession databaseSession, AccessMethod accessMethod, ServerSettingsSetter serverSettingsSetter) {
        super(databaseSession, accessMethod);
        this.bimServer = bimServer;
        this.serverSettingsSetter = serverSettingsSetter;
    }

    @Override
    public Void execute() throws UserException, BimserverLockConflictException, BimserverDatabaseException {
        ServerSettings serverSettings = (ServerSettings)this.getDatabaseSession().getSingle(StorePackage.eINSTANCE.getServerSettings(), OldQuery.getDefault());
        this.serverSettingsSetter.set(serverSettings);
        this.getDatabaseSession().store((IdEObject)serverSettings);
        this.getDatabaseSession().addPostCommitAction(new PostCommitAction(){

            @Override
            public void execute() throws UserException {
                SetServerSettingDatabaseAction.this.bimServer.getServerSettingsCache().updateCache();
            }
        });
        return null;
    }
}

