/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.database.actions;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.google.common.base.Charsets;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import org.bimserver.BimServer;
import org.bimserver.BimserverDatabaseException;
import org.bimserver.GenerateGeometryResult;
import org.bimserver.SummaryMap;
import org.bimserver.database.BimserverLockConflictException;
import org.bimserver.database.DatabaseSession;
import org.bimserver.database.OldQuery;
import org.bimserver.database.PostCommitAction;
import org.bimserver.database.Record;
import org.bimserver.database.SearchingRecordIterator;
import org.bimserver.database.actions.CreateRevisionResult;
import org.bimserver.database.actions.GenericCheckinDatabaseAction;
import org.bimserver.database.actions.ProgressListener;
import org.bimserver.database.queries.ConcreteRevisionStackFrame;
import org.bimserver.database.queries.QueryObjectProvider;
import org.bimserver.database.queries.QueryTypeStackFrame;
import org.bimserver.database.queries.om.Include;
import org.bimserver.database.queries.om.Query;
import org.bimserver.database.queries.om.QueryException;
import org.bimserver.database.queries.om.QueryPart;
import org.bimserver.emf.IdEObject;
import org.bimserver.emf.PackageMetaData;
import org.bimserver.geometry.GeometryGenerationReport;
import org.bimserver.geometry.StreamingGeometryGenerator;
import org.bimserver.mail.MailSystem;
import org.bimserver.models.geometry.GeometryPackage;
import org.bimserver.models.log.AccessMethod;
import org.bimserver.models.log.NewRevisionAdded;
import org.bimserver.models.store.ConcreteRevision;
import org.bimserver.models.store.ExtendedData;
import org.bimserver.models.store.File;
import org.bimserver.models.store.IfcHeader;
import org.bimserver.models.store.NewService;
import org.bimserver.models.store.PluginBundleVersion;
import org.bimserver.models.store.Project;
import org.bimserver.models.store.Revision;
import org.bimserver.models.store.Service;
import org.bimserver.models.store.User;
import org.bimserver.notifications.NewRevisionNotification;
import org.bimserver.plugins.deserializers.ByteProgressReporter;
import org.bimserver.plugins.deserializers.DatabaseInterface;
import org.bimserver.plugins.deserializers.StreamingDeserializer;
import org.bimserver.shared.HashMapVirtualObject;
import org.bimserver.shared.QueryContext;
import org.bimserver.shared.exceptions.UserException;
import org.bimserver.webservices.authorization.Authorization;
import org.bimserver.webservices.authorization.ExplicitRightsAuthorization;
import org.bimserver.webservices.impl.RestartableInputStream;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamingCheckinDatabaseAction
extends GenericCheckinDatabaseAction {
    private static final Logger LOGGER = LoggerFactory.getLogger(StreamingCheckinDatabaseAction.class);
    private final String comment;
    private final long poid;
    private final BimServer bimServer;
    private ConcreteRevision concreteRevision;
    private Project project;
    private Authorization authorization;
    private String fileName;
    private long fileSize;
    private InputStream inputStream;
    private StreamingDeserializer deserializer;
    private long newServiceId;
    private Revision newRevision;
    private PackageMetaData packageMetaData;
    private PluginBundleVersion pluginBundleVersion;

    public StreamingCheckinDatabaseAction(BimServer bimServer, DatabaseSession databaseSession, AccessMethod accessMethod, long poid, Authorization authorization, String comment, String fileName, InputStream inputStream, StreamingDeserializer deserializer, long fileSize, long newServiceId, PluginBundleVersion pluginBundleVersion) {
        super(databaseSession, accessMethod);
        this.bimServer = bimServer;
        this.poid = poid;
        this.authorization = authorization;
        this.comment = comment;
        this.fileName = fileName;
        this.inputStream = inputStream;
        this.deserializer = deserializer;
        this.fileSize = fileSize;
        this.newServiceId = newServiceId;
        this.pluginBundleVersion = pluginBundleVersion;
    }

    public HashMapVirtualObject getByOid(PackageMetaData packageMetaData, DatabaseSession databaseSession, long roid, long oid) throws JsonParseException, JsonMappingException, IOException, QueryException, BimserverDatabaseException {
        Query query = new Query("test", packageMetaData);
        QueryPart queryPart = query.createQueryPart();
        queryPart.addOid(oid);
        QueryObjectProvider queryObjectProvider = new QueryObjectProvider(databaseSession, this.bimServer, query, Collections.singleton(roid), packageMetaData);
        HashMapVirtualObject first = queryObjectProvider.next();
        return first;
    }

    @Override
    public ConcreteRevision execute() throws UserException, BimserverDatabaseException {
        try {
            ExplicitRightsAuthorization explicitRightsAuthorization;
            this.bimServer.getCheckinsInProgress().put(this.poid, this.getActingUid());
            if (this.inputStream instanceof RestartableInputStream) {
                ((RestartableInputStream)this.inputStream).restartIfAtEnd();
            }
            this.getDatabaseSession().clearPostCommitActions();
            if (this.fileSize != -1L) {
                this.setProgress("Deserializing IFC file...", 0);
            }
            this.authorization.canCheckin(this.poid);
            this.project = this.getProjectByPoid(this.poid);
            int nrConcreteRevisionsBefore = this.project.getConcreteRevisions().size();
            User user = this.getUserByUoid(this.authorization.getUoid());
            if (this.project == null) {
                throw new UserException("Project with poid " + this.poid + " not found");
            }
            if (!this.authorization.hasRightsOnProjectOrSuperProjects(user, this.project)) {
                throw new UserException("User has no rights to checkin models to this project");
            }
            if (!MailSystem.isValidEmailAddress(user.getUsername())) {
                throw new UserException("Users must have a valid e-mail address to checkin");
            }
            this.packageMetaData = this.bimServer.getMetaDataManager().getPackageMetaData(this.project.getSchema());
            CreateRevisionResult result = this.createNewConcreteRevision(this.getDatabaseSession(), -1L, this.project, user, this.comment.trim());
            this.newRevision = result.getRevisions().get(0);
            long newRoid = this.newRevision.getOid();
            QueryContext queryContext = new QueryContext((DatabaseInterface)this.getDatabaseSession(), this.packageMetaData, result.getConcreteRevision().getProject().getId().intValue(), result.getConcreteRevision().getId().intValue(), newRoid, -1);
            final AtomicLong bytesRead = new AtomicLong();
            this.deserializer.setProgressReporter(new ByteProgressReporter(){

                public void progress(long byteNumber) {
                    bytesRead.set(byteNumber);
                    if (StreamingCheckinDatabaseAction.this.fileSize != -1L) {
                        int perc = (int)(100.0 * (double)byteNumber / (double)StreamingCheckinDatabaseAction.this.fileSize);
                        StreamingCheckinDatabaseAction.this.setProgress("Deserializing...", perc);
                    }
                }
            });
            long size = this.deserializer.read(this.inputStream, this.fileName, this.fileSize, queryContext);
            Set eClasses = this.deserializer.getSummaryMap().keySet();
            Map<EClass, Long> startOids = this.getDatabaseSession().getStartOids();
            if (startOids == null) {
                throw new BimserverDatabaseException("No objects changed");
            }
            HashMap<EClass, Long> oidCounters = new HashMap<EClass, Long>();
            int s = 0;
            for (Object eClass : eClasses) {
                if (DatabaseSession.perRecordVersioning((EClass)eClass)) continue;
                ++s;
            }
            ByteBuffer buffer = ByteBuffer.allocate(8 * s);
            buffer.order(ByteOrder.LITTLE_ENDIAN);
            for (EClass eClass : eClasses) {
                if (DatabaseSession.perRecordVersioning(eClass)) continue;
                long oid = startOids.get(eClass);
                oidCounters.put(eClass, oid);
                buffer.putLong(oid);
            }
            queryContext.setOidCounters(oidCounters);
            this.concreteRevision = result.getConcreteRevision();
            this.concreteRevision.setOidCounters(buffer.array());
            this.setProgress("Generating inverses/opposites...", -1);
            this.fixInverses(this.packageMetaData, newRoid);
            ProgressListener progressListener = new ProgressListener(){

                @Override
                public void updateProgress(String state, int percentage) {
                    StreamingCheckinDatabaseAction.this.setProgress("Generating geometry...", percentage);
                }
            };
            GeometryGenerationReport report = new GeometryGenerationReport();
            report.setOriginalIfcFileName(this.fileName);
            report.setOriginalIfcFileSize(bytesRead.get());
            report.setNumberOfObjects(size);
            report.setOriginalDeserializer(this.pluginBundleVersion.getGroupId() + "." + this.pluginBundleVersion.getArtifactId() + ":" + this.pluginBundleVersion.getVersion());
            StreamingGeometryGenerator geometryGenerator = new StreamingGeometryGenerator(this.bimServer, progressListener, -1L, report);
            this.setProgress("Generating geometry...", 0);
            GenerateGeometryResult generateGeometry = geometryGenerator.generateGeometry(this.getActingUid(), this.getDatabaseSession(), queryContext);
            for (Revision other : this.concreteRevision.getRevisions()) {
                other.setHasGeometry(true);
            }
            this.concreteRevision.setMinBounds(generateGeometry.getMinBoundsAsVector3f());
            this.concreteRevision.setMaxBounds(generateGeometry.getMaxBoundsAsVector3f());
            this.setProgress("Doing other stuff...", -1);
            eClasses = this.deserializer.getSummaryMap().keySet();
            s = startOids.containsKey(GeometryPackage.eINSTANCE.getGeometryInfo()) && startOids.containsKey(GeometryPackage.eINSTANCE.getGeometryData()) ? 2 : 0;
            for (EClass eClass : eClasses) {
                if (DatabaseSession.perRecordVersioning(eClass)) continue;
                ++s;
            }
            buffer = ByteBuffer.allocate(8 * s);
            buffer.order(ByteOrder.LITTLE_ENDIAN);
            for (EClass eClass : eClasses) {
                long oid = startOids.get(eClass);
                if (DatabaseSession.perRecordVersioning(eClass)) continue;
                buffer.putLong(oid);
            }
            if (startOids.containsKey(GeometryPackage.eINSTANCE.getGeometryInfo()) && startOids.containsKey(GeometryPackage.eINSTANCE.getGeometryData())) {
                buffer.putLong(startOids.get(GeometryPackage.eINSTANCE.getGeometryInfo()));
                buffer.putLong(startOids.get(GeometryPackage.eINSTANCE.getGeometryData()));
            }
            this.concreteRevision = result.getConcreteRevision();
            this.concreteRevision.setOidCounters(buffer.array());
            ConcreteRevisionStackFrame.clearCache(this.concreteRevision.getOid());
            result.getConcreteRevision().setSize(Long.valueOf(size));
            Iterator<Object> iterator = result.getRevisions().iterator();
            while (iterator.hasNext()) {
                Revision revision;
                revision.setSize(Long.valueOf(((revision = (Revision)iterator.next()).getSize() == null ? 0L : revision.getSize()) + this.concreteRevision.getSize()));
            }
            IfcHeader ifcHeader = this.deserializer.getIfcHeader();
            if (ifcHeader != null) {
                this.getDatabaseSession().store((IdEObject)ifcHeader);
                this.concreteRevision.setIfcHeader(ifcHeader);
            }
            this.project.getConcreteRevisions().add((Object)this.concreteRevision);
            NewRevisionAdded newRevisionAdded = this.getDatabaseSession().create(NewRevisionAdded.class);
            newRevisionAdded.setDate(new Date());
            newRevisionAdded.setExecutor(user);
            final Revision revision = (Revision)this.concreteRevision.getRevisions().get(0);
            if (this.newServiceId != -1L) {
                NewService newService = (NewService)this.getDatabaseSession().get(this.newServiceId, OldQuery.getDefault());
                revision.getServicesLinked().add((Object)newService);
            }
            this.concreteRevision.setSummary(new SummaryMap(this.packageMetaData, this.deserializer.getSummaryMap()).toRevisionSummary(this.getDatabaseSession()));
            if (this.authorization instanceof ExplicitRightsAuthorization && (explicitRightsAuthorization = (ExplicitRightsAuthorization)this.authorization).getSoid() != -1L) {
                Service service = (Service)this.getDatabaseSession().get(explicitRightsAuthorization.getSoid(), OldQuery.getDefault());
                revision.setService(service);
            }
            newRevisionAdded.setRevision(revision);
            newRevisionAdded.setProject(this.project);
            newRevisionAdded.setAccessMethod(this.getAccessMethod());
            if (nrConcreteRevisionsBefore != 0) {
                this.concreteRevision.setClear(true);
            }
            ExtendedData extendedData = this.getDatabaseSession().create(ExtendedData.class);
            File file = this.getDatabaseSession().create(File.class);
            byte[] bytes = report.toHtml().getBytes(Charsets.UTF_8);
            file.setData(bytes);
            file.setFilename("geometrygenerationreport.html");
            file.setMime("text/html");
            file.setSize((long)bytes.length);
            User actingUser = this.getUserByUoid(this.authorization.getUoid());
            extendedData.setUser(actingUser);
            extendedData.setTitle("Geometry generation report");
            extendedData.setAdded(new Date());
            extendedData.setSize((long)file.getData().length);
            extendedData.setFile(file);
            revision.getExtendedData().add((Object)extendedData);
            extendedData.setProject(revision.getProject());
            extendedData.setRevision(revision);
            this.getDatabaseSession().store((IdEObject)file);
            this.getDatabaseSession().store((IdEObject)extendedData);
            if (extendedData.getSchema() != null) {
                this.getDatabaseSession().store((IdEObject)extendedData.getSchema());
            }
            this.getDatabaseSession().addPostCommitAction(new PostCommitAction(){

                @Override
                public void execute() throws UserException {
                    StreamingCheckinDatabaseAction.this.bimServer.getNotificationsManager().notify(new NewRevisionNotification(StreamingCheckinDatabaseAction.this.bimServer, StreamingCheckinDatabaseAction.this.project.getOid(), revision.getOid(), StreamingCheckinDatabaseAction.this.authorization));
                }
            });
            this.getDatabaseSession().store((IdEObject)this.concreteRevision);
            this.getDatabaseSession().store((IdEObject)this.project);
        }
        catch (Throwable e) {
            if (e instanceof BimserverDatabaseException) {
                throw (BimserverDatabaseException)e;
            }
            if (e instanceof UserException) {
                throw (UserException)e;
            }
            throw new UserException(e);
        }
        finally {
            this.bimServer.getCheckinsInProgress().remove(this.poid);
        }
        return this.concreteRevision;
    }

    private void fixInverses(PackageMetaData packageMetaData, long newRoid) throws QueryException, JsonParseException, JsonMappingException, IOException, BimserverDatabaseException {
        HashMap<Long, HashMapVirtualObject> cache = new HashMap<Long, HashMapVirtualObject>();
        Query query = new Query("Inverses fixer", packageMetaData);
        int nrTypes = 0;
        HashSet<EClass> uniqueTypes = new HashSet<EClass>();
        for (EClass eClass : this.deserializer.getSummaryMap().keySet()) {
            if (!packageMetaData.hasInverses(eClass)) continue;
            QueryPart queryPart = query.createQueryPart();
            queryPart.addType(eClass, true);
            uniqueTypes.add(eClass);
            ++nrTypes;
            for (EReference eReference : packageMetaData.getAllHasInverseReferences(eClass)) {
                Include include = queryPart.createInclude();
                include.addType(eClass, true);
                include.addField(eReference.getName());
            }
        }
        QueryObjectProvider queryObjectProvider = new QueryObjectProvider(this.getDatabaseSession(), this.bimServer, query, Collections.singleton(newRoid), packageMetaData);
        HashMapVirtualObject next = queryObjectProvider.next();
        EClass lastEClass = null;
        int currentType = 0;
        while (next != null) {
            if (next.eClass() != lastEClass && uniqueTypes.contains(next.eClass()) && queryObjectProvider.getStackFrame() instanceof QueryTypeStackFrame) {
                lastEClass = next.eClass();
                this.setProgress("Generating inverses", 100 * ++currentType / nrTypes);
            }
            if (packageMetaData.hasInverses(next.eClass())) {
                for (EReference eReference : packageMetaData.getAllHasInverseReferences(next.eClass())) {
                    Object reference = next.eGet((EStructuralFeature)eReference);
                    if (reference == null) continue;
                    if (eReference.isMany()) {
                        List references = (List)reference;
                        for (Long refOid : references) {
                            this.fixInverses(packageMetaData, newRoid, cache, next, eReference, refOid);
                        }
                        continue;
                    }
                    this.fixInverses(packageMetaData, newRoid, cache, next, eReference, (Long)reference);
                }
            }
            next = queryObjectProvider.next();
        }
        this.setProgress("Storing data", -1);
        for (HashMapVirtualObject referencedObject : cache.values()) {
            referencedObject.saveOverwrite();
        }
    }

    private void fixInverses(PackageMetaData packageMetaData, long newRoid, Map<Long, HashMapVirtualObject> cache, HashMapVirtualObject next, EReference eReference, long refOid) throws JsonParseException, JsonMappingException, IOException, QueryException, BimserverDatabaseException {
        EReference oppositeReference;
        HashMapVirtualObject referencedObject = cache.get(refOid);
        if (referencedObject == null) {
            referencedObject = this.getByOid(packageMetaData, this.getDatabaseSession(), newRoid, refOid);
            if (referencedObject == null) {
                throw new BimserverDatabaseException("Referenced object with oid " + refOid + " (" + this.getDatabaseSession().getEClassForOid(refOid).getName() + "), referenced from " + next.eClass().getName() + " not found");
            }
            cache.put(refOid, referencedObject);
        }
        if ((oppositeReference = packageMetaData.getInverseOrOpposite(referencedObject.eClass(), (EStructuralFeature)eReference)) == null) {
            if (eReference.getName().equals("RelatedElements") && referencedObject.eClass().getName().equals("IfcSpace")) {
                // empty if block
            }
        } else if (oppositeReference.isMany()) {
            Object existingList = referencedObject.eGet((EStructuralFeature)oppositeReference);
            if (existingList != null) {
                int currentSize = ((List)existingList).size();
                referencedObject.setListItemReference((EStructuralFeature)oppositeReference, currentSize, next.eClass(), Long.valueOf(next.getOid()), 0);
            } else {
                referencedObject.setListItemReference((EStructuralFeature)oppositeReference, 0, next.eClass(), Long.valueOf(next.getOid()), 0);
            }
        } else {
            referencedObject.setReference((EStructuralFeature)oppositeReference, next.getOid(), 0);
        }
    }

    public String getFileName() {
        return this.fileName;
    }

    public ConcreteRevision getConcreteRevision() {
        return this.concreteRevision;
    }

    public Revision getRevision() {
        return (Revision)this.concreteRevision.getRevisions().get(0);
    }

    public long getCroid() {
        return this.concreteRevision.getOid();
    }

    public long getActingUid() {
        return this.authorization.getUoid();
    }

    public long getPoid() {
        return this.poid;
    }

    @Override
    public void close() throws IOException {
        this.inputStream.close();
    }

    @Override
    public void rollback() throws BimserverDatabaseException {
        LOGGER.info("Rolling back");
        int pid = this.newRevision.getProject().getId();
        int rid = this.newRevision.getRid();
        Map<EClass, Long> startOids = this.getDatabaseSession().getStartOids();
        if (startOids == null) {
            throw new BimserverDatabaseException("No objects changed");
        }
        int deleted = 0;
        for (EClass eClass : startOids.keySet()) {
            Long startOid = startOids.get(eClass);
            ByteBuffer mustStartWith = ByteBuffer.wrap(new byte[4]);
            mustStartWith.putInt(pid);
            ByteBuffer startSearchWith = ByteBuffer.wrap(new byte[12]);
            startSearchWith.putInt(pid);
            startSearchWith.putLong(startOid);
            String tableName = eClass.getEPackage().getName() + "_" + eClass.getName();
            try {
                if (this.getDatabaseSession().getKeyValueStore().isTransactional(this.getDatabaseSession(), tableName)) continue;
                try {
                    SearchingRecordIterator recordIterator = this.getDatabaseSession().getKeyValueStore().getRecordIterator(tableName, mustStartWith.array(), startSearchWith.array(), this.getDatabaseSession());
                    Throwable throwable = null;
                    try {
                        Record record = recordIterator.next();
                        while (record != null) {
                            ByteBuffer keyBuffer = ByteBuffer.wrap(record.getKey());
                            keyBuffer.getInt();
                            keyBuffer.getLong();
                            int keyRid = -keyBuffer.getInt();
                            if (keyRid == rid) {
                                this.getDatabaseSession().getKeyValueStore().delete(tableName, record.getKey(), this.getDatabaseSession());
                                ++deleted;
                            }
                            record = recordIterator.next();
                        }
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (recordIterator == null) continue;
                        if (throwable != null) {
                            try {
                                recordIterator.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        recordIterator.close();
                    }
                }
                catch (BimserverLockConflictException e) {
                    e.printStackTrace();
                }
                catch (BimserverDatabaseException e) {
                    e.printStackTrace();
                }
            }
            catch (BimserverDatabaseException e1) {
                e1.printStackTrace();
            }
        }
        LOGGER.info("Deleted " + deleted + " objects in rollback");
    }
}

