/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.database.actions;

import java.util.Date;
import org.bimserver.BimServer;
import org.bimserver.BimserverDatabaseException;
import org.bimserver.database.BimserverLockConflictException;
import org.bimserver.database.DatabaseSession;
import org.bimserver.database.PostCommitAction;
import org.bimserver.database.actions.BimDatabaseAction;
import org.bimserver.emf.IdEObject;
import org.bimserver.interfaces.SConverter;
import org.bimserver.interfaces.objects.SLogAction;
import org.bimserver.models.log.AccessMethod;
import org.bimserver.models.log.ProjectUndeleted;
import org.bimserver.models.store.ObjectState;
import org.bimserver.models.store.Project;
import org.bimserver.models.store.User;
import org.bimserver.models.store.UserType;
import org.bimserver.shared.exceptions.UserException;
import org.bimserver.webservices.authorization.Authorization;

public class UndeleteProjectDatabaseAction
extends BimDatabaseAction<Boolean> {
    private final long poid;
    private Authorization authorization;
    private BimServer bimServer;

    public UndeleteProjectDatabaseAction(BimServer bimServer, DatabaseSession databaseSession, AccessMethod accessMethod, long poid, Authorization authorization) {
        super(databaseSession, accessMethod);
        this.bimServer = bimServer;
        this.poid = poid;
        this.authorization = authorization;
    }

    @Override
    public Boolean execute() throws UserException, BimserverDatabaseException, BimserverLockConflictException {
        User actingUser = this.getUserByUoid(this.authorization.getUoid());
        Project project = this.getProjectByPoid(this.poid);
        if (project == null) {
            throw new UserException("No Project with oid " + this.poid + " found");
        }
        if (actingUser.getUserType() == UserType.ADMIN || actingUser.getHasRightsOn().contains((Object)project)) {
            project.setState(ObjectState.ACTIVE);
            final ProjectUndeleted projectUndeleted = this.getDatabaseSession().create(ProjectUndeleted.class);
            projectUndeleted.setAccessMethod(this.getAccessMethod());
            projectUndeleted.setDate(new Date());
            projectUndeleted.setExecutor(actingUser);
            projectUndeleted.setProject(project);
            this.getDatabaseSession().addPostCommitAction(new PostCommitAction(){

                @Override
                public void execute() throws UserException {
                    UndeleteProjectDatabaseAction.this.bimServer.getNotificationsManager().notify((SLogAction)new SConverter().convertToSObject(projectUndeleted));
                }
            });
            this.getDatabaseSession().store((IdEObject)project);
            return true;
        }
        throw new UserException("No rights to undelete this project");
    }
}

