/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.database.actions;

import java.util.Date;
import org.bimserver.BimServer;
import org.bimserver.BimserverDatabaseException;
import org.bimserver.database.BimserverLockConflictException;
import org.bimserver.database.DatabaseSession;
import org.bimserver.database.PostCommitAction;
import org.bimserver.database.actions.BimDatabaseAction;
import org.bimserver.emf.IdEObject;
import org.bimserver.interfaces.SConverter;
import org.bimserver.interfaces.objects.SLogAction;
import org.bimserver.models.log.AccessMethod;
import org.bimserver.models.log.UserUndeleted;
import org.bimserver.models.store.ObjectState;
import org.bimserver.models.store.User;
import org.bimserver.models.store.UserType;
import org.bimserver.shared.exceptions.UserException;
import org.bimserver.webservices.authorization.Authorization;

public class UndeleteUserDatabaseAction
extends BimDatabaseAction<Boolean> {
    private final long uoid;
    private Authorization authorization;
    private BimServer bimServer;

    public UndeleteUserDatabaseAction(BimServer bimServer, DatabaseSession databaseSession, AccessMethod accessMethod, Authorization authorization, long uoid) {
        super(databaseSession, accessMethod);
        this.bimServer = bimServer;
        this.authorization = authorization;
        this.uoid = uoid;
    }

    @Override
    public Boolean execute() throws UserException, BimserverDatabaseException, BimserverLockConflictException {
        User actingUser = this.getUserByUoid(this.authorization.getUoid());
        if (actingUser.getUserType() != UserType.ADMIN) {
            throw new UserException("Only administrators can undelete users");
        }
        User user = this.getUserByUoid(this.uoid);
        if (user == null) {
            throw new UserException("No User with oid " + this.uoid + " found");
        }
        final UserUndeleted userUndeleted = this.getDatabaseSession().create(UserUndeleted.class);
        userUndeleted.setAccessMethod(this.getAccessMethod());
        userUndeleted.setDate(new Date());
        userUndeleted.setExecutor(actingUser);
        userUndeleted.setUser(user);
        this.getDatabaseSession().addPostCommitAction(new PostCommitAction(){

            @Override
            public void execute() throws UserException {
                UndeleteUserDatabaseAction.this.bimServer.getNotificationsManager().notify((SLogAction)new SConverter().convertToSObject(userUndeleted));
            }
        });
        user.setState(ObjectState.ACTIVE);
        this.getDatabaseSession().store((IdEObject)user);
        return true;
    }
}

