/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.database.actions;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.List;
import org.bimserver.BimServer;
import org.bimserver.BimserverDatabaseException;
import org.bimserver.database.BimserverLockConflictException;
import org.bimserver.database.DatabaseSession;
import org.bimserver.database.actions.BimDatabaseAction;
import org.bimserver.models.log.AccessMethod;
import org.bimserver.plugins.MavenPluginLocation;
import org.bimserver.shared.exceptions.ServerException;
import org.bimserver.shared.exceptions.UserException;
import org.eclipse.aether.resolution.ArtifactResolutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpdatePluginBundle
extends BimDatabaseAction<Void> {
    private static final Logger LOGGER = LoggerFactory.getLogger(UpdatePluginBundle.class);
    private BimServer bimServer;
    private String groupId;
    private String artifactId;
    private String version;
    private String repository;

    public UpdatePluginBundle(DatabaseSession databaseSession, AccessMethod accessMethod, BimServer bimServer, String repository, String groupId, String artifactId, String version) {
        super(databaseSession, accessMethod);
        this.bimServer = bimServer;
        this.repository = repository;
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.version = version;
    }

    @Override
    public Void execute() throws UserException, BimserverLockConflictException, BimserverDatabaseException, ServerException {
        MavenPluginLocation mavenPluginLocation = this.bimServer.getMavenPluginRepository().getPluginLocation(this.repository, this.groupId, this.artifactId);
        try {
            Path jarFile = mavenPluginLocation.getVersionJar(this.version);
            Path pomFile = mavenPluginLocation.getVersionPom(this.version);
            try {
                List plugins = null;
                try {
                    plugins = this.bimServer.getPluginManager().getPluginInformationFromPluginFile((InputStream)new ByteArrayInputStream(mavenPluginLocation.getVersionPluginXml(this.version)));
                }
                catch (ArtifactResolutionException e) {
                    plugins = this.bimServer.getPluginManager().getPluginInformationFromJar(jarFile);
                }
                this.bimServer.getPluginManager().update(mavenPluginLocation.getPluginVersionIdentifier(this.version), mavenPluginLocation.getPluginBundle(this.version), mavenPluginLocation.getPluginBundleVersion(this.version), jarFile, pomFile, plugins);
            }
            catch (Exception e) {
                throw new UserException((Throwable)e);
            }
        }
        catch (Exception e) {
            LOGGER.error("", (Throwable)e);
            throw new UserException((Throwable)e);
        }
        return null;
    }
}

