/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.database.actions;

import java.util.Date;
import org.bimserver.BimServer;
import org.bimserver.BimserverDatabaseException;
import org.bimserver.database.BimserverLockConflictException;
import org.bimserver.database.DatabaseSession;
import org.bimserver.database.PostCommitAction;
import org.bimserver.database.actions.BimDatabaseAction;
import org.bimserver.emf.IdEObject;
import org.bimserver.interfaces.SConverter;
import org.bimserver.interfaces.objects.SLogAction;
import org.bimserver.interfaces.objects.SProject;
import org.bimserver.models.log.AccessMethod;
import org.bimserver.models.log.ProjectUpdated;
import org.bimserver.models.store.Project;
import org.bimserver.models.store.SIPrefix;
import org.bimserver.models.store.User;
import org.bimserver.shared.exceptions.UserException;
import org.bimserver.webservices.authorization.Authorization;

public class UpdateProjectDatabaseAction
extends BimDatabaseAction<Void> {
    private final SProject sProject;
    private Authorization authorization;
    private BimServer bimServer;

    public UpdateProjectDatabaseAction(BimServer bimServer, DatabaseSession databaseSession, AccessMethod accessMethod, Authorization authorization, SProject sProject) {
        super(databaseSession, accessMethod);
        this.bimServer = bimServer;
        this.authorization = authorization;
        this.sProject = sProject;
    }

    @Override
    public Void execute() throws UserException, BimserverLockConflictException, BimserverDatabaseException {
        User actingUser = this.getUserByUoid(this.authorization.getUoid());
        Project project = this.getProjectByPoid(this.sProject.getOid());
        if (project == null) {
            throw new UserException("Project with pid " + this.sProject.getOid() + " not found");
        }
        if (this.sProject.getName().trim().equals("")) {
            throw new UserException("Project name cannot be empty");
        }
        if (!this.authorization.hasRightsOnProjectOrSuperProjects(actingUser, project)) {
            throw new UserException("User has no rights to update project properties");
        }
        if (project.getParent() == null) {
            if (!this.sProject.getName().equals(project.getName())) {
                for (Project p : this.getProjectsByName(this.sProject.getName())) {
                    if (p.getParent() != null) continue;
                    throw new UserException("Project name must be unique");
                }
            }
        } else {
            Project parent = project.getParent();
            for (Project subProject : parent.getSubProjects()) {
                if (!subProject.getName().equals(this.sProject.getName()) || subProject == project) continue;
                throw new UserException("Project name must be unique within parent project (" + parent.getName() + ")");
            }
        }
        project.setSendEmailOnNewRevision(this.sProject.isSendEmailOnNewRevision());
        project.setName(this.sProject.getName());
        project.setDescription(this.sProject.getDescription());
        project.setExportLengthMeasurePrefix(SIPrefix.get((int)this.sProject.getExportLengthMeasurePrefix().getOrdinal()));
        final ProjectUpdated projectUpdated = this.getDatabaseSession().create(ProjectUpdated.class);
        projectUpdated.setAccessMethod(this.getAccessMethod());
        projectUpdated.setDate(new Date());
        projectUpdated.setExecutor(actingUser);
        projectUpdated.setProject(project);
        this.getDatabaseSession().addPostCommitAction(new PostCommitAction(){

            @Override
            public void execute() throws UserException {
                UpdateProjectDatabaseAction.this.bimServer.getNotificationsManager().notify((SLogAction)new SConverter().convertToSObject(projectUpdated));
            }
        });
        this.getDatabaseSession().store((IdEObject)project);
        return null;
    }
}

