/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.database.actions;

import org.bimserver.BimserverDatabaseException;
import org.bimserver.database.BimserverLockConflictException;
import org.bimserver.database.DatabaseSession;
import org.bimserver.database.OldQuery;
import org.bimserver.database.actions.UpdateDatabaseAction;
import org.bimserver.emf.QueryInterface;
import org.bimserver.models.log.AccessMethod;
import org.bimserver.models.store.RenderEnginePluginConfiguration;
import org.bimserver.models.store.StorePackage;
import org.bimserver.shared.exceptions.UserException;

public class UpdateRenderEngineDatabaseAction
extends UpdateDatabaseAction<RenderEnginePluginConfiguration> {
    private final RenderEnginePluginConfiguration renderEngine;

    public UpdateRenderEngineDatabaseAction(DatabaseSession databaseSession, AccessMethod accessMethod, RenderEnginePluginConfiguration renderEngine) {
        super(databaseSession, accessMethod, renderEngine);
        this.renderEngine = renderEngine;
    }

    @Override
    public Void execute() throws UserException, BimserverLockConflictException, BimserverDatabaseException {
        RenderEnginePluginConfiguration oldRenderEngine = (RenderEnginePluginConfiguration)this.getDatabaseSession().get(StorePackage.eINSTANCE.getRenderEnginePluginConfiguration(), this.renderEngine.getOid(), (QueryInterface)OldQuery.getDefault());
        if (oldRenderEngine.getEnabled().booleanValue() && !this.renderEngine.getEnabled().booleanValue() && !this.renderEngine.getSerializers().isEmpty()) {
            throw new UserException("Cannot disable render engine with serializers");
        }
        return super.execute();
    }
}

