/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.database.actions;

import java.util.Date;
import org.bimserver.BimServer;
import org.bimserver.BimserverDatabaseException;
import org.bimserver.database.BimserverLockConflictException;
import org.bimserver.database.DatabaseSession;
import org.bimserver.database.PostCommitAction;
import org.bimserver.database.actions.BimDatabaseAction;
import org.bimserver.emf.IdEObject;
import org.bimserver.interfaces.SConverter;
import org.bimserver.interfaces.objects.SLogAction;
import org.bimserver.interfaces.objects.SRevision;
import org.bimserver.models.log.AccessMethod;
import org.bimserver.models.log.RevisionUpdated;
import org.bimserver.models.store.Project;
import org.bimserver.models.store.Revision;
import org.bimserver.models.store.User;
import org.bimserver.shared.exceptions.UserException;
import org.bimserver.webservices.authorization.Authorization;

public class UpdateRevisionDatabaseAction
extends BimDatabaseAction<Void> {
    private final SRevision sRevision;
    private Authorization authorization;
    private BimServer bimServer;

    public UpdateRevisionDatabaseAction(BimServer bimServer, DatabaseSession databaseSession, AccessMethod accessMethod, Authorization authorization, SRevision sRevision) {
        super(databaseSession, accessMethod);
        this.bimServer = bimServer;
        this.authorization = authorization;
        this.sRevision = sRevision;
    }

    @Override
    public Void execute() throws UserException, BimserverLockConflictException, BimserverDatabaseException {
        User actingUser = this.getUserByUoid(this.authorization.getUoid());
        Revision revision = this.getRevisionByRoid(this.sRevision.getOid());
        if (revision == null) {
            throw new UserException("Revision with pid " + this.sRevision.getOid() + " not found");
        }
        Project project = revision.getProject();
        if (!this.authorization.hasRightsOnProjectOrSuperProjects(actingUser, project)) {
            throw new UserException("User has no rights to update project properties");
        }
        final RevisionUpdated revisionUpdated = this.getDatabaseSession().create(RevisionUpdated.class);
        revisionUpdated.setRevision(revision);
        revisionUpdated.setDate(new Date());
        revisionUpdated.setExecutor(actingUser);
        revisionUpdated.setAccessMethod(this.getAccessMethod());
        this.getDatabaseSession().addPostCommitAction(new PostCommitAction(){

            @Override
            public void execute() throws UserException {
                UpdateRevisionDatabaseAction.this.bimServer.getNotificationsManager().notify((SLogAction)new SConverter().convertToSObject(revisionUpdated));
            }
        });
        revision.setTag(this.sRevision.getTag());
        this.getDatabaseSession().store((IdEObject)revision);
        return null;
    }
}

