/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.database.actions;

import org.bimserver.BimServer;
import org.bimserver.BimserverDatabaseException;
import org.bimserver.database.BimserverLockConflictException;
import org.bimserver.database.DatabaseSession;
import org.bimserver.database.OldQuery;
import org.bimserver.database.actions.BimDatabaseAction;
import org.bimserver.emf.IdEObject;
import org.bimserver.models.log.AccessMethod;
import org.bimserver.models.store.ModelCheckerInstance;
import org.bimserver.plugins.modelchecker.ModelCheckerPlugin;
import org.bimserver.shared.exceptions.UserException;

public class ValidateModelCheckerDatabaseAction
extends BimDatabaseAction<Void> {
    private BimServer bimServer;
    private long modelCheckerInstanceOid;

    public ValidateModelCheckerDatabaseAction(BimServer bimServer, DatabaseSession databaseSession, AccessMethod accessMethod, long modelCheckerInstanceOid) {
        super(databaseSession, accessMethod);
        this.bimServer = bimServer;
        this.modelCheckerInstanceOid = modelCheckerInstanceOid;
    }

    @Override
    public Void execute() throws UserException, BimserverLockConflictException, BimserverDatabaseException {
        ModelCheckerInstance modelCheckerInstance = (ModelCheckerInstance)this.getDatabaseSession().get(this.modelCheckerInstanceOid, OldQuery.getDefault());
        ModelCheckerPlugin modelCheckerPlugin = this.bimServer.getPluginManager().getModelCheckerPlugin(modelCheckerInstance.getModelCheckerPluginClassName(), true);
        if (modelCheckerPlugin == null) {
            throw new UserException("Model Checker Plugin \"" + modelCheckerInstance.getModelCheckerPluginClassName() + "\" not found/enabled");
        }
        modelCheckerInstance.setValid(true);
        this.getDatabaseSession().store((IdEObject)modelCheckerInstance);
        return null;
    }
}

