/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.database.berkeley;

import com.sleepycat.je.Cursor;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.LockMode;
import com.sleepycat.je.OperationStatus;
import org.bimserver.database.BimserverLockConflictException;
import org.bimserver.database.Record;
import org.bimserver.database.RecordIterator;
import org.bimserver.database.berkeley.BerkeleyKeyValueStore;
import org.bimserver.database.berkeley.BerkeleyRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BerkeleyRecordIterator
implements RecordIterator {
    private long cursorId;
    private static final Logger LOGGER = LoggerFactory.getLogger(BerkeleyRecordIterator.class);
    private final Cursor cursor;
    private BerkeleyKeyValueStore berkeleyKeyValueStore;

    public BerkeleyRecordIterator(Cursor cursor, BerkeleyKeyValueStore berkeleyKeyValueStore, long cursorId) {
        this.cursor = cursor;
        this.berkeleyKeyValueStore = berkeleyKeyValueStore;
        this.cursorId = cursorId;
    }

    public long getCursorId() {
        return this.cursorId;
    }

    @Override
    public Record next() {
        DatabaseEntry key = new DatabaseEntry();
        DatabaseEntry value = new DatabaseEntry();
        try {
            OperationStatus next = this.cursor.getNext(key, value, LockMode.DEFAULT);
            if (next == OperationStatus.SUCCESS) {
                return new BerkeleyRecord(key, value);
            }
            return null;
        }
        catch (DatabaseException e) {
            LOGGER.error("", (Throwable)e);
            return null;
        }
    }

    @Override
    public void close() {
        try {
            this.cursor.close();
            this.berkeleyKeyValueStore.removeOpenCursor(this.cursorId);
        }
        catch (DatabaseException e) {
            LOGGER.error("", (Throwable)e);
        }
    }

    @Override
    public Record last() throws BimserverLockConflictException {
        DatabaseEntry key = new DatabaseEntry();
        DatabaseEntry value = new DatabaseEntry();
        try {
            OperationStatus next = this.cursor.getLast(key, value, LockMode.DEFAULT);
            if (next == OperationStatus.SUCCESS) {
                return new BerkeleyRecord(key, value);
            }
            return null;
        }
        catch (DatabaseException databaseException) {
            return null;
        }
    }
}

