/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.database.berkeley;

import com.sleepycat.je.Cursor;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.LockConflictException;
import com.sleepycat.je.LockMode;
import com.sleepycat.je.OperationStatus;
import java.util.Arrays;
import org.bimserver.database.BimserverLockConflictException;
import org.bimserver.database.Record;
import org.bimserver.database.SearchingRecordIterator;
import org.bimserver.database.berkeley.BerkeleyKeyValueStore;
import org.bimserver.database.berkeley.BerkeleyRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BerkeleySearchingRecordIterator
implements SearchingRecordIterator {
    private static final Logger LOGGER = LoggerFactory.getLogger(BerkeleySearchingRecordIterator.class);
    private final Cursor cursor;
    private final byte[] mustStartWith;
    private byte[] nextStartSearchingAt;
    private long cursorId;
    private BerkeleyKeyValueStore berkeleyKeyValueStore;

    public BerkeleySearchingRecordIterator(Cursor cursor, BerkeleyKeyValueStore berkeleyKeyValueStore, long cursorId, byte[] mustStartWith, byte[] startSearchingAt) throws BimserverLockConflictException {
        this.cursor = cursor;
        this.berkeleyKeyValueStore = berkeleyKeyValueStore;
        this.cursorId = cursorId;
        this.mustStartWith = mustStartWith;
        this.nextStartSearchingAt = startSearchingAt;
    }

    public long getCursorId() {
        return this.cursorId;
    }

    private Record getFirstNext(byte[] startSearchingAt) throws BimserverLockConflictException {
        this.nextStartSearchingAt = null;
        DatabaseEntry key = new DatabaseEntry(startSearchingAt);
        DatabaseEntry value = new DatabaseEntry();
        try {
            OperationStatus next = this.cursor.getSearchKeyRange(key, value, LockMode.DEFAULT);
            if (next == OperationStatus.SUCCESS) {
                byte[] firstBytes = new byte[this.mustStartWith.length];
                System.arraycopy(key.getData(), 0, firstBytes, 0, this.mustStartWith.length);
                if (Arrays.equals(firstBytes, this.mustStartWith)) {
                    return new BerkeleyRecord(key, value);
                }
            }
        }
        catch (LockConflictException e) {
            throw new BimserverLockConflictException(e);
        }
        catch (DatabaseException e) {
            LOGGER.error("", (Throwable)e);
        }
        return null;
    }

    @Override
    public Record next() throws BimserverLockConflictException {
        if (this.nextStartSearchingAt != null) {
            return this.getFirstNext(this.nextStartSearchingAt);
        }
        DatabaseEntry key = new DatabaseEntry();
        DatabaseEntry value = new DatabaseEntry();
        try {
            OperationStatus next = this.cursor.getNext(key, value, LockMode.DEFAULT);
            if (next == OperationStatus.SUCCESS) {
                byte[] firstBytes = new byte[this.mustStartWith.length];
                System.arraycopy(key.getData(), 0, firstBytes, 0, this.mustStartWith.length);
                if (Arrays.equals(firstBytes, this.mustStartWith)) {
                    return new BerkeleyRecord(key, value);
                }
            }
        }
        catch (LockConflictException e) {
            throw new BimserverLockConflictException(e);
        }
        catch (DatabaseException e) {
            LOGGER.error("", (Throwable)e);
        }
        return null;
    }

    @Override
    public void close() {
        try {
            this.cursor.close();
            this.berkeleyKeyValueStore.removeOpenCursor(this.cursorId);
        }
        catch (DatabaseException e) {
            LOGGER.error("", (Throwable)e);
        }
    }

    @Override
    public Record next(byte[] startSearchingAt) throws BimserverLockConflictException {
        return this.getFirstNext(startSearchingAt);
    }

    @Override
    public Record last() throws BimserverLockConflictException {
        if (this.nextStartSearchingAt != null) {
            return this.getFirstNext(this.nextStartSearchingAt);
        }
        DatabaseEntry key = new DatabaseEntry();
        DatabaseEntry value = new DatabaseEntry();
        try {
            OperationStatus next = this.cursor.getLast(key, value, LockMode.DEFAULT);
            if (next == OperationStatus.SUCCESS) {
                byte[] firstBytes = new byte[this.mustStartWith.length];
                System.arraycopy(key.getData(), 0, firstBytes, 0, this.mustStartWith.length);
                if (Arrays.equals(firstBytes, this.mustStartWith)) {
                    return new BerkeleyRecord(key, value);
                }
            }
        }
        catch (LockConflictException e) {
            throw new BimserverLockConflictException(e);
        }
        catch (DatabaseException e) {
            LOGGER.error("", (Throwable)e);
        }
        return null;
    }
}

