/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.database.berkeley;

import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.LockConflictException;
import com.sleepycat.je.Transaction;
import org.bimserver.BimserverDatabaseException;
import org.bimserver.database.BimTransaction;
import org.bimserver.database.BimserverLockConflictException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BerkeleyTransaction
implements BimTransaction {
    private static final Logger LOGGER = LoggerFactory.getLogger(BerkeleyTransaction.class);
    private final Transaction transaction;
    private boolean transactionAlive = true;

    public BerkeleyTransaction(Transaction transaction) {
        this.transaction = transaction;
    }

    public Transaction getTransaction() {
        return this.transaction;
    }

    @Override
    public void setName(String name) {
        this.transaction.setName(name);
    }

    @Override
    public void close() {
        if (this.transactionAlive) {
            this.rollback();
        }
    }

    @Override
    public void rollback() {
        try {
            this.transaction.abort();
            this.transactionAlive = false;
        }
        catch (DatabaseException e) {
            LOGGER.error("", (Throwable)e);
        }
    }

    @Override
    public void commit() throws BimserverLockConflictException, BimserverDatabaseException {
        try {
            this.transaction.commit();
            this.transactionAlive = false;
        }
        catch (LockConflictException e) {
            throw new BimserverLockConflictException(e);
        }
        catch (DatabaseException e) {
            throw new BimserverDatabaseException((Throwable)e);
        }
    }

    @Override
    public long getId() {
        return this.transaction.getId();
    }
}

