/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.database.migrations.change;

import java.nio.ByteBuffer;
import org.bimserver.BimserverDatabaseException;
import org.bimserver.database.BimserverLockConflictException;
import org.bimserver.database.Database;
import org.bimserver.database.DatabaseSession;
import org.bimserver.database.KeyValueStore;
import org.bimserver.database.Record;
import org.bimserver.database.RecordIterator;
import org.bimserver.database.migrations.NotImplementedException;
import org.bimserver.database.migrations.Schema;
import org.bimserver.database.migrations.change.Change;
import org.bimserver.models.ifc2x3tc1.Ifc2x3tc1Package;
import org.bimserver.models.ifc4.Ifc4Package;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AddIndexChange
implements Change {
    private static final Logger LOGGER = LoggerFactory.getLogger(AddIndexChange.class);
    private EStructuralFeature eStructuralFeature;
    private Schema schema;

    public AddIndexChange(Schema schema, EStructuralFeature eStructuralFeature) {
        this.schema = schema;
        this.eStructuralFeature = eStructuralFeature;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void change(Database database, DatabaseSession databaseSession) throws NotImplementedException, BimserverDatabaseException {
        EClass eClass = this.eStructuralFeature.getEContainingClass();
        KeyValueStore keyValueStore = database.getKeyValueStore();
        for (EClass subClass : this.schema.getSubClasses(eClass)) {
            try {
                if (subClass.getEAnnotation("nodatabase") != null) continue;
                String indexTableName = subClass.getEPackage().getName() + "_" + subClass.getName() + "_" + this.eStructuralFeature.getName();
                boolean transactional = subClass.getEPackage() != Ifc4Package.eINSTANCE && subClass.getEPackage() != Ifc2x3tc1Package.eINSTANCE;
                keyValueStore.createIndexTable(indexTableName, databaseSession, transactional);
                try (RecordIterator recordIterator = keyValueStore.getRecordIterator(subClass.getEPackage().getName() + "_" + subClass.getName(), databaseSession);){
                    Record record = recordIterator.next();
                    while (record != null) {
                        ByteBuffer buffer = ByteBuffer.wrap(record.getValue());
                        byte[] featureBytes = databaseSession.extractFeatureBytes(databaseSession, buffer, subClass, this.eStructuralFeature);
                        if (featureBytes != null) {
                            keyValueStore.store(indexTableName, featureBytes, record.getKey(), databaseSession);
                        }
                        record = recordIterator.next();
                    }
                }
            }
            catch (BimserverLockConflictException e) {
                LOGGER.error("", (Throwable)((Object)e));
            }
        }
    }

    @Override
    public void doSchemaChanges(Schema schema) {
    }
}

