/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.database.migrations.change;

import java.nio.ByteBuffer;
import org.bimserver.BimserverDatabaseException;
import org.bimserver.database.BimserverLockConflictException;
import org.bimserver.database.Database;
import org.bimserver.database.DatabaseSession;
import org.bimserver.database.KeyValueStore;
import org.bimserver.database.Record;
import org.bimserver.database.RecordIterator;
import org.bimserver.database.migrations.NotImplementedException;
import org.bimserver.database.migrations.Schema;
import org.bimserver.database.migrations.change.Change;
import org.bimserver.emf.PackageMetaData;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NewAttributeChange
implements Change {
    private static final Logger LOGGER = LoggerFactory.getLogger(NewAttributeChange.class);
    private final EAttribute eAttribute;
    private final Schema schema;
    private int nrFeaturesBefore;

    public NewAttributeChange(Schema schema, int nrFeaturesBefore, EAttribute eAttribute) {
        this.schema = schema;
        this.nrFeaturesBefore = nrFeaturesBefore;
        this.eAttribute = eAttribute;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void change(Database database, DatabaseSession databaseSession) throws NotImplementedException, BimserverDatabaseException {
        EClass eClass = this.eAttribute.getEContainingClass();
        KeyValueStore keyValueStore = database.getKeyValueStore();
        for (EClass subClass : this.schema.getSubClasses(eClass)) {
            try {
                if (subClass.getEAnnotation("nodatabase") != null) continue;
                try (RecordIterator recordIterator = keyValueStore.getRecordIterator(subClass.getEPackage().getName() + "_" + subClass.getName(), databaseSession);){
                    Record record = recordIterator.next();
                    while (record != null) {
                        ByteBuffer buffer = ByteBuffer.wrap(record.getValue());
                        PackageMetaData packageMetaData = database.getMetaDataManager().getPackageMetaData(subClass.getEPackage().getName());
                        int newUnsettedLength = packageMetaData.getUnsettedLength(subClass);
                        int previousUnsettedLength = packageMetaData.getUnsettedLength(subClass, this.eAttribute);
                        byte[] unsetted = new byte[newUnsettedLength];
                        buffer.get(unsetted, 0, previousUnsettedLength);
                        int fieldCounter = 0;
                        for (EStructuralFeature feature : subClass.getEAllStructuralFeatures()) {
                            if (!packageMetaData.useForDatabaseStorage(subClass, feature)) continue;
                            if (feature == this.eAttribute) {
                                int n = fieldCounter / 8;
                                unsetted[n] = (byte)(unsetted[n] | 1 << fieldCounter % 8);
                            }
                            ++fieldCounter;
                        }
                        int extra = 0;
                        ByteBuffer newBuffer = ByteBuffer.allocate(record.getValue().length + (newUnsettedLength - previousUnsettedLength) + extra);
                        newBuffer.put(unsetted);
                        buffer.position(previousUnsettedLength);
                        newBuffer.put(buffer);
                        keyValueStore.store(subClass.getEPackage().getName() + "_" + subClass.getName(), record.getKey(), newBuffer.array(), databaseSession);
                        record = recordIterator.next();
                    }
                }
            }
            catch (BimserverLockConflictException e) {
                LOGGER.error("", (Throwable)((Object)e));
            }
        }
    }

    @Override
    public void doSchemaChanges(Schema schema) {
    }
}

