/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.database.migrations.change;

import java.util.Set;
import org.bimserver.BimserverDatabaseException;
import org.bimserver.database.BimserverLockConflictException;
import org.bimserver.database.Database;
import org.bimserver.database.DatabaseSession;
import org.bimserver.database.migrations.Schema;
import org.bimserver.database.migrations.change.Change;
import org.bimserver.database.migrations.change.NewClassChange;
import org.bimserver.models.geometry.GeometryPackage;
import org.bimserver.models.ifc2x3tc1.Ifc2x3tc1Package;
import org.bimserver.models.ifc4.Ifc4Package;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EPackage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NewClassBulkChange
implements Change {
    private static final Logger LOGGER = LoggerFactory.getLogger(NewClassChange.class);
    private final Set<EClass> eClasses;
    private final EPackage ePackage;

    public NewClassBulkChange(EPackage ePackage, Set<EClass> eClasses) {
        this.ePackage = ePackage;
        this.eClasses = eClasses;
    }

    @Override
    public void change(Database database, DatabaseSession databaseSession) throws BimserverDatabaseException {
        boolean transactional = this.ePackage != Ifc2x3tc1Package.eINSTANCE && this.ePackage != Ifc4Package.eINSTANCE && this.ePackage != GeometryPackage.eINSTANCE;
        LOGGER.info("Creating " + this.eClasses.size() + " " + (transactional ? "transactional" : "non transactional") + " tables for package " + this.ePackage.getName());
        for (EClass eClass : this.eClasses) {
            String tableName = eClass.getEPackage().getName() + "_" + eClass.getName();
            if (eClass.getEAnnotation("nodatabase") != null) continue;
            try {
                boolean created = database.createTable(eClass, databaseSession, transactional);
                if (created) continue;
                throw new BimserverDatabaseException("Could not create table " + tableName);
            }
            catch (BimserverLockConflictException e) {
                LOGGER.error("", (Throwable)((Object)e));
            }
        }
    }

    @Override
    public void doSchemaChanges(Schema schema) {
        for (EClass eClass : this.eClasses) {
            schema.addEClass(eClass);
        }
    }
}

