/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.database.migrations.change;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.bimserver.BimserverDatabaseException;
import org.bimserver.database.BimserverLockConflictException;
import org.bimserver.database.Database;
import org.bimserver.database.DatabaseSession;
import org.bimserver.database.KeyValueStore;
import org.bimserver.database.Record;
import org.bimserver.database.RecordIterator;
import org.bimserver.database.migrations.NotImplementedException;
import org.bimserver.database.migrations.Schema;
import org.bimserver.database.migrations.change.Change;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NewReferenceChange
implements Change {
    private static final Logger LOGGER = LoggerFactory.getLogger(NewReferenceChange.class);
    private final EReference eReference;
    private final Schema schema;
    private int nrFeaturesBefore;

    public NewReferenceChange(Schema schema, int nrFeaturesBefore, EReference eReference) {
        this.schema = schema;
        this.nrFeaturesBefore = nrFeaturesBefore;
        this.eReference = eReference;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void change(Database database, DatabaseSession databaseSession) throws NotImplementedException, BimserverDatabaseException {
        EClass eClass = this.eReference.getEContainingClass();
        KeyValueStore keyValueStore = database.getKeyValueStore();
        for (EClass subClass : this.schema.getSubClasses(eClass)) {
            try {
                if (subClass.getEAnnotation("nodatabase") != null) continue;
                try (RecordIterator recordIterator = keyValueStore.getRecordIterator(subClass.getEPackage().getName() + "_" + subClass.getName(), databaseSession);){
                    Record record = recordIterator.next();
                    while (record != null) {
                        ByteBuffer buffer = ByteBuffer.wrap(record.getValue());
                        int nrStartBytesBefore = (int)Math.ceil((double)this.nrFeaturesBefore / 8.0);
                        int nrStartBytesAfter = (int)Math.ceil((double)(this.nrFeaturesBefore + 1) / 8.0);
                        byte x = buffer.get();
                        if (x != nrStartBytesBefore) {
                            throw new BimserverDatabaseException("Size to not match");
                        }
                        byte[] unsetted = new byte[nrStartBytesAfter];
                        buffer.get(unsetted, 0, x);
                        if (this.eReference.isUnsettable()) {
                            int n = (this.nrFeaturesBefore + 1) / 8;
                            unsetted[n] = (byte)(unsetted[n] | 1 << (this.nrFeaturesBefore + 1) % 8);
                        }
                        int extra = 0;
                        if (!this.eReference.isUnsettable()) {
                            extra = this.eReference.isMany() ? 4 : 2;
                        }
                        ByteBuffer newBuffer = ByteBuffer.allocate(record.getValue().length + (nrStartBytesAfter - nrStartBytesBefore) + extra);
                        newBuffer.put((byte)nrStartBytesAfter);
                        newBuffer.put(unsetted);
                        buffer.position(1 + nrStartBytesBefore);
                        newBuffer.put(buffer);
                        if (!this.eReference.isUnsettable()) {
                            if (this.eReference.isMany()) {
                                newBuffer.putInt(0);
                            } else {
                                buffer.order(ByteOrder.LITTLE_ENDIAN);
                                newBuffer.putShort((short)-1);
                                buffer.order(ByteOrder.BIG_ENDIAN);
                            }
                        }
                        keyValueStore.store(subClass.getEPackage().getName() + "_" + subClass.getName(), record.getKey(), newBuffer.array(), databaseSession);
                        record = recordIterator.next();
                    }
                }
            }
            catch (BimserverLockConflictException e) {
                LOGGER.error("", (Throwable)((Object)e));
            }
        }
    }

    @Override
    public void doSchemaChanges(Schema schema) {
    }
}

