/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.database.queries;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.HashMap;
import java.util.Map;
import org.bimserver.BimserverDatabaseException;
import org.bimserver.database.DatabaseSession;
import org.bimserver.database.actions.AbstractDownloadDatabaseAction;
import org.bimserver.database.queries.QueryObjectProvider;
import org.bimserver.database.queries.QueryStackFrame;
import org.bimserver.database.queries.StackFrame;
import org.bimserver.emf.PackageMetaData;
import org.bimserver.models.store.ConcreteRevision;
import org.bimserver.models.store.Revision;
import org.bimserver.plugins.deserializers.DatabaseInterface;
import org.bimserver.shared.QueryContext;
import org.eclipse.emf.ecore.EClass;

public class ConcreteRevisionStackFrame
extends StackFrame {
    private final QueryObjectProvider queryObjectProvider;
    private final PackageMetaData packageMetaData;
    private final QueryContext queryContext;
    private static final Map<Long, Map<EClass, Long>> reusableQueryContexts = new HashMap<Long, Map<EClass, Long>>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConcreteRevisionStackFrame(QueryObjectProvider queryObjectProvider, ConcreteRevision concreteRevision) {
        this.queryObjectProvider = queryObjectProvider;
        int highestStopId = AbstractDownloadDatabaseAction.findHighestStopRid(concreteRevision.getProject(), concreteRevision);
        this.packageMetaData = queryObjectProvider.getMetaDataManager().getPackageMetaData(concreteRevision.getProject().getSchema());
        Revision revision = (Revision)concreteRevision.getRevisions().get(0);
        this.queryContext = new QueryContext((DatabaseInterface)queryObjectProvider.getDatabaseSession(), this.packageMetaData, concreteRevision.getProject().getId().intValue(), concreteRevision.getId().intValue(), revision.getOid(), highestStopId);
        if (concreteRevision.getOidCounters() != null) {
            Class<?> clazz = this.getClass();
            synchronized (clazz) {
                if (reusableQueryContexts.containsKey(concreteRevision.getOid())) {
                    this.queryContext.setOidCounters(reusableQueryContexts.get(concreteRevision.getOid()));
                } else {
                    try {
                        Map<EClass, Long> updateOidCounters = this.updateOidCounters(concreteRevision, queryObjectProvider.getDatabaseSession());
                        this.queryContext.setOidCounters(updateOidCounters);
                        reusableQueryContexts.put(concreteRevision.getOid(), updateOidCounters);
                    }
                    catch (BimserverDatabaseException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    public static void clearCache(long croid) {
        reusableQueryContexts.remove(croid);
    }

    private Map<EClass, Long> updateOidCounters(ConcreteRevision subRevision, DatabaseSession databaseSession) throws BimserverDatabaseException {
        if (subRevision.getOidCounters() != null) {
            HashMap<EClass, Long> oidCounters = new HashMap<EClass, Long>(subRevision.getOidCounters().length / 8);
            ByteBuffer buffer = ByteBuffer.wrap(subRevision.getOidCounters());
            buffer.order(ByteOrder.LITTLE_ENDIAN);
            for (int i = 0; i < buffer.capacity() / 8; ++i) {
                long oid = buffer.getLong();
                EClass eClass = databaseSession.getEClass((short)oid);
                oidCounters.put(eClass, oid);
            }
            return oidCounters;
        }
        return null;
    }

    @Override
    public boolean process() throws BimserverDatabaseException, JsonParseException, JsonMappingException, IOException {
        this.queryObjectProvider.push(new QueryStackFrame(this.queryObjectProvider, this.queryContext));
        return true;
    }
}

