/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.database.queries;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.google.common.base.Charsets;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.bimserver.BimserverDatabaseException;
import org.bimserver.database.DatabaseSession;
import org.bimserver.database.ObjectIdentifier;
import org.bimserver.database.Record;
import org.bimserver.database.SearchingRecordIterator;
import org.bimserver.database.queries.DatabaseReadingStackFrame;
import org.bimserver.database.queries.QueryObjectProvider;
import org.bimserver.database.queries.om.CanInclude;
import org.bimserver.database.queries.om.QueryException;
import org.bimserver.database.queries.om.QueryPart;
import org.bimserver.plugins.deserializers.DatabaseInterface;
import org.bimserver.shared.HashMapVirtualObject;
import org.bimserver.shared.QueryContext;
import org.bimserver.utils.BinUtils;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;

public class QueryClassificationsAndTypesStackFrame
extends DatabaseReadingStackFrame {
    private EClass eClass;
    private Set<String> classifications;
    private SearchingRecordIterator typeRecordIterator;
    private Record record;
    private Set<Long> allowedOids = new HashSet<Long>();

    public QueryClassificationsAndTypesStackFrame(QueryObjectProvider queryObjectProvider, EClass eClass, QueryPart partialQuery, QueryContext reusable, Set<String> classifications) throws BimserverDatabaseException {
        super(reusable, queryObjectProvider, partialQuery);
        this.eClass = eClass;
        this.classifications = classifications;
        DatabaseSession databaseSession = this.getQueryObjectProvider().getDatabaseSession();
        String schemaName = eClass.getEPackage().getName();
        EClass classificationReferenceClass = databaseSession.getEClass(schemaName, "IfcClassificationReference");
        EClass relAssociatesClassificationReferenceClass = databaseSession.getEClass(schemaName, "IfcRelAssociatesClassification");
        EStructuralFeature classificationKeyFeature = classificationReferenceClass.getEStructuralFeature(1);
        for (String classification : classifications) {
            List<ObjectIdentifier> objectIdentifiers = this.getOids(classificationReferenceClass, classificationKeyFeature, classification, databaseSession, reusable.getPid(), reusable.getRid());
            for (ObjectIdentifier objectIdentifier : objectIdentifiers) {
                List<ObjectIdentifier> relAssociates = this.getOids(relAssociatesClassificationReferenceClass, relAssociatesClassificationReferenceClass.getEStructuralFeature("RelatingClassification"), objectIdentifier.getOid(), databaseSession, reusable.getPid(), reusable.getRid());
                for (ObjectIdentifier objectIdentifier2 : relAssociates) {
                    HashMapVirtualObject relAssociatesClassification = this.getByOid(objectIdentifier2.getOid());
                    List relatedObjects = (List)relAssociatesClassification.eGet(relAssociatesClassificationReferenceClass.getEStructuralFeature("RelatedObjects"));
                    this.allowedOids.addAll(relatedObjects);
                }
            }
        }
        String tableName = eClass.getEPackage().getName() + "_" + eClass.getName();
        if (this.getReusable().getOidCounters() != null) {
            if (!this.getReusable().getOidCounters().containsKey(eClass)) {
                return;
            }
            long startOid = (Long)this.getReusable().getOidCounters().get(eClass);
            ByteBuffer tmp = ByteBuffer.allocate(12);
            tmp.putInt(this.getReusable().getPid());
            tmp.putLong(startOid + 1L);
            this.typeRecordIterator = queryObjectProvider.getDatabaseSession().getKeyValueStore().getRecordIterator(tableName, BinUtils.intToByteArray((int)this.getReusable().getPid()), tmp.array(), queryObjectProvider.getDatabaseSession());
            this.record = this.typeRecordIterator.next();
        } else {
            this.typeRecordIterator = queryObjectProvider.getDatabaseSession().getKeyValueStore().getRecordIterator(tableName, BinUtils.intToByteArray((int)this.getReusable().getPid()), BinUtils.intToByteArray((int)this.getReusable().getPid()), queryObjectProvider.getDatabaseSession());
            this.record = this.typeRecordIterator.next();
        }
    }

    public ObjectIdentifier getOid(EClass eClass, EAttribute attribute, Object value, DatabaseInterface databaseInterface, int pid, int rid) throws BimserverDatabaseException {
        if (attribute.getEAnnotation("singleindex") != null) {
            String indexTableName = attribute.getEContainingClass().getEPackage().getName() + "_" + eClass.getName() + "_" + attribute.getName();
            byte[] queryBytes = null;
            if (value instanceof String) {
                queryBytes = ((String)value).getBytes(Charsets.UTF_8);
            } else if (value instanceof Integer) {
                queryBytes = BinUtils.intToByteArray((int)((Integer)value));
            } else {
                throw new BimserverDatabaseException("Unsupported type " + value);
            }
            ByteBuffer valueBuffer = ByteBuffer.allocate(queryBytes.length + 8);
            valueBuffer.putInt(pid);
            valueBuffer.putInt(-rid);
            valueBuffer.put(queryBytes);
            byte[] firstDuplicate = databaseInterface.get(indexTableName, valueBuffer.array());
            if (firstDuplicate != null) {
                ByteBuffer buffer = ByteBuffer.wrap(firstDuplicate);
                buffer.getInt();
                long oid = buffer.getLong();
                return new ObjectIdentifier(oid, (short)oid);
            }
        } else {
            throw new UnsupportedOperationException(eClass.getName() + "." + attribute.getName() + " does not have a singleindex");
        }
        return null;
    }

    public List<ObjectIdentifier> getOids(EClass eClass, EStructuralFeature eStructuralFeature, Object value, DatabaseInterface databaseInterface, int pid, int rid) throws BimserverDatabaseException {
        if (eStructuralFeature.getEAnnotation("singleindex") != null) {
            ArrayList<ObjectIdentifier> result = new ArrayList<ObjectIdentifier>();
            String indexTableName = eStructuralFeature.getEContainingClass().getEPackage().getName() + "_" + eClass.getName() + "_" + eStructuralFeature.getName();
            byte[] queryBytes = null;
            if (value instanceof String) {
                queryBytes = ((String)value).getBytes(Charsets.UTF_8);
            } else if (value instanceof Integer) {
                queryBytes = BinUtils.intToByteArray((int)((Integer)value));
            } else if (value instanceof Long) {
                queryBytes = BinUtils.longToByteArray((long)((Long)value));
            } else {
                throw new BimserverDatabaseException("Unsupported type " + value);
            }
            ByteBuffer valueBuffer = ByteBuffer.allocate(queryBytes.length + 8);
            valueBuffer.putInt(pid);
            valueBuffer.putInt(-rid);
            valueBuffer.put(queryBytes);
            List duplicates = databaseInterface.getDuplicates(indexTableName, valueBuffer.array());
            for (byte[] duplicate : duplicates) {
                ByteBuffer buffer = ByteBuffer.wrap(duplicate);
                buffer.getInt();
                long oid = buffer.getLong();
                result.add(new ObjectIdentifier(oid, (short)oid));
            }
            return result;
        }
        throw new UnsupportedOperationException();
    }

    @Override
    boolean process() throws BimserverDatabaseException, QueryException, JsonParseException, JsonMappingException, IOException {
        if (this.typeRecordIterator == null) {
            return true;
        }
        if (this.record == null) {
            this.currentObject = null;
            this.typeRecordIterator.close();
            return true;
        }
        this.currentObject = null;
        ByteBuffer nextKeyStart = ByteBuffer.allocate(12);
        this.getQueryObjectProvider().incReads();
        ByteBuffer keyBuffer = ByteBuffer.wrap(this.record.getKey());
        int keyPid = keyBuffer.getInt();
        long keyOid = keyBuffer.getLong();
        int keyRid = -keyBuffer.getInt();
        ByteBuffer valueBuffer = ByteBuffer.wrap(this.record.getValue());
        DatabaseSession.GetResult map = this.getMap(this.eClass, this.eClass, valueBuffer, keyPid, keyOid, keyRid);
        if (map == DatabaseSession.GetResult.CONTINUE_WITH_NEXT_OID) {
            nextKeyStart.position(0);
            nextKeyStart.putInt(this.getReusable().getPid());
            nextKeyStart.putLong(keyOid + 1L);
            this.record = this.typeRecordIterator.next(nextKeyStart.array());
        } else {
            this.record = this.typeRecordIterator.next();
        }
        if (this.currentObject != null && !this.allowedOids.contains(this.currentObject.getOid())) {
            this.currentObject = null;
        }
        this.processPossibleIncludes(this.currentObject, this.eClass, (CanInclude)this.getQueryPart());
        return false;
    }
}

