/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.database.queries;

import com.google.common.base.Charsets;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.bimserver.BimserverDatabaseException;
import org.bimserver.database.ObjectIdentifier;
import org.bimserver.database.queries.DatabaseReadingStackFrame;
import org.bimserver.database.queries.QueryObjectProvider;
import org.bimserver.database.queries.QueryOidsAndTypesStackFrame;
import org.bimserver.database.queries.om.QueryException;
import org.bimserver.database.queries.om.QueryPart;
import org.bimserver.plugins.deserializers.DatabaseInterface;
import org.bimserver.shared.QueryContext;
import org.bimserver.utils.BinUtils;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;

public class QueryGuidsAndTypesStackFrame
extends DatabaseReadingStackFrame {
    private EClass eClass;
    private QueryObjectProvider queryObjectProvider;
    private Set<Long> oids;
    private QueryContext reusable;
    private QueryPart jsonQuery;
    private boolean converted;

    public QueryGuidsAndTypesStackFrame(QueryObjectProvider queryObjectProvider, EClass eClass, QueryPart jsonQuery, QueryContext reusable, Set<String> guids) throws BimserverDatabaseException {
        super(reusable, queryObjectProvider, null);
        this.queryObjectProvider = queryObjectProvider;
        this.eClass = eClass;
        this.jsonQuery = jsonQuery;
        this.reusable = reusable;
        this.oids = new HashSet<Long>();
        for (String guid : guids) {
            EAttribute globalIdFeature = (EAttribute)eClass.getEStructuralFeature("GlobalId");
            if (globalIdFeature == null) {
                this.converted = true;
                continue;
            }
            ObjectIdentifier oidOfGuid = this.getOidOfGuidAlternative(eClass, globalIdFeature, guid, reusable.getDatabaseInterface(), reusable.getPid(), reusable.getRid());
            if (oidOfGuid == null) continue;
            this.oids.add(oidOfGuid.getOid());
        }
        if (this.oids.isEmpty()) {
            this.converted = true;
        }
    }

    public ObjectIdentifier getOidOfGuidAlternative(EClass eClass, EAttribute attribute, Object value, DatabaseInterface databaseInterface, int pid, int rid) throws BimserverDatabaseException {
        if (attribute.getEAnnotation("singleindex") != null) {
            String indexTableName = attribute.getEContainingClass().getEPackage().getName() + "_" + eClass.getName() + "_" + attribute.getName();
            byte[] queryBytes = null;
            if (value instanceof String) {
                queryBytes = ((String)value).getBytes(Charsets.UTF_8);
            } else if (value instanceof Integer) {
                queryBytes = BinUtils.intToByteArray((int)((Integer)value));
            } else {
                throw new BimserverDatabaseException("Unsupported type " + value);
            }
            ByteBuffer valueBuffer = ByteBuffer.allocate(queryBytes.length + 8);
            valueBuffer.putInt(pid);
            valueBuffer.putInt(-rid);
            valueBuffer.put(queryBytes);
            byte[] firstDuplicate = databaseInterface.get(indexTableName, valueBuffer.array());
            if (firstDuplicate != null) {
                ByteBuffer buffer = ByteBuffer.wrap(firstDuplicate);
                buffer.getInt();
                long oid = buffer.getLong();
                return new ObjectIdentifier(oid, (short)oid);
            }
        } else {
            throw new UnsupportedOperationException("Attribute " + attribute.getName() + " does not have the \"singleindex\" annotation");
        }
        return null;
    }

    @Override
    public boolean process() throws BimserverDatabaseException, QueryException {
        if (this.converted) {
            return true;
        }
        this.converted = true;
        this.queryObjectProvider.push(new QueryOidsAndTypesStackFrame(this.queryObjectProvider, this.eClass, this.jsonQuery, this.reusable, new ArrayList<Long>(this.oids)));
        return false;
    }
}

