/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.database.queries;

import java.nio.ByteBuffer;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.bimserver.BimserverDatabaseException;
import org.bimserver.database.DatabaseSession;
import org.bimserver.database.Record;
import org.bimserver.database.SearchingRecordIterator;
import org.bimserver.database.queries.DatabaseReadingStackFrame;
import org.bimserver.database.queries.ObjectProvidingStackFrame;
import org.bimserver.database.queries.QueryObjectProvider;
import org.bimserver.database.queries.om.CanInclude;
import org.bimserver.database.queries.om.Properties;
import org.bimserver.database.queries.om.QueryException;
import org.bimserver.database.queries.om.QueryPart;
import org.bimserver.shared.HashMapVirtualObject;
import org.bimserver.shared.HashMapWrappedVirtualObject;
import org.bimserver.shared.QueryContext;
import org.bimserver.utils.BinUtils;
import org.eclipse.emf.common.util.Enumerator;
import org.eclipse.emf.ecore.EClass;

public class QueryPropertiesAndTypesStackFrame
extends DatabaseReadingStackFrame
implements ObjectProvidingStackFrame {
    private EClass eClass;
    private SearchingRecordIterator typeRecordIterator;
    private Record record;
    private Map<String, Properties> properties;

    public QueryPropertiesAndTypesStackFrame(QueryObjectProvider queryObjectProvider, EClass eClass, QueryPart queryPart, QueryContext reusable, Map<String, Properties> properties) throws BimserverDatabaseException {
        super(reusable, queryObjectProvider, queryPart);
        this.eClass = eClass;
        this.properties = properties;
        String tableName = eClass.getEPackage().getName() + "_" + eClass.getName();
        if (this.getReusable().getOidCounters() != null) {
            if (!this.getReusable().getOidCounters().containsKey(eClass)) {
                return;
            }
            long startOid = (Long)this.getReusable().getOidCounters().get(eClass);
            ByteBuffer tmp = ByteBuffer.allocate(12);
            tmp.putInt(this.getReusable().getPid());
            tmp.putLong(startOid + 1L);
            this.typeRecordIterator = queryObjectProvider.getDatabaseSession().getKeyValueStore().getRecordIterator(tableName, BinUtils.intToByteArray((int)this.getReusable().getPid()), tmp.array(), queryObjectProvider.getDatabaseSession());
            this.record = this.typeRecordIterator.next();
        } else {
            this.typeRecordIterator = queryObjectProvider.getDatabaseSession().getKeyValueStore().getRecordIterator(tableName, BinUtils.intToByteArray((int)this.getReusable().getPid()), BinUtils.intToByteArray((int)this.getReusable().getPid()), queryObjectProvider.getDatabaseSession());
            this.record = this.typeRecordIterator.next();
        }
    }

    @Override
    public boolean process() throws BimserverDatabaseException, QueryException {
        if (this.typeRecordIterator == null) {
            return true;
        }
        if (this.record == null) {
            this.currentObject = null;
            this.typeRecordIterator.close();
            return true;
        }
        this.currentObject = null;
        ByteBuffer nextKeyStart = ByteBuffer.allocate(12);
        this.getQueryObjectProvider().incReads();
        ByteBuffer keyBuffer = ByteBuffer.wrap(this.record.getKey());
        int keyPid = keyBuffer.getInt();
        long keyOid = keyBuffer.getLong();
        int keyRid = -keyBuffer.getInt();
        ByteBuffer valueBuffer = ByteBuffer.wrap(this.record.getValue());
        DatabaseSession.GetResult map = this.getMap(this.eClass, this.eClass, valueBuffer, keyPid, keyOid, keyRid);
        if (map == DatabaseSession.GetResult.CONTINUE_WITH_NEXT_OID) {
            nextKeyStart.position(0);
            nextKeyStart.putInt(this.getReusable().getPid());
            nextKeyStart.putLong(keyOid + 1L);
            this.record = this.typeRecordIterator.next(nextKeyStart.array());
        } else {
            this.record = this.typeRecordIterator.next();
        }
        if (this.currentObject != null) {
            DatabaseSession databaseSession = this.getQueryObjectProvider().getDatabaseSession();
            List isDefinedByOids = (List)this.currentObject.get("IsDefinedBy");
            int totalQueryProperties = 0;
            for (String key : this.properties.keySet()) {
                totalQueryProperties += this.properties.get(key).count();
            }
            if (isDefinedByOids != null) {
                HashSet<String> propertyKeysMatched = new HashSet<String>();
                for (Long definedByOid : isDefinedByOids) {
                    HashMapVirtualObject ifcPropertySet;
                    String propertySetName;
                    Properties propertiesObject;
                    EClass eClass = databaseSession.getEClassForOid(definedByOid);
                    if (!this.getPackageMetaData().getEClass("IfcRelDefinesByProperties").isSuperTypeOf(eClass)) continue;
                    HashMapVirtualObject ifcRelDefinesByProperties = this.getByOid(definedByOid);
                    Long ifcPropertySetDefinition = (Long)ifcRelDefinesByProperties.get("RelatingPropertyDefinition");
                    if (!this.getPackageMetaData().getEClass("IfcPropertySet").isSuperTypeOf(databaseSession.getEClassForOid(ifcPropertySetDefinition)) || (propertiesObject = this.properties.get(propertySetName = (String)(ifcPropertySet = this.getByOid(ifcPropertySetDefinition)).get("Name"))) == null) continue;
                    List properties = (List)ifcPropertySet.get("HasProperties");
                    Iterator iterator = properties.iterator();
                    while (iterator.hasNext()) {
                        long propertyOid = (Long)iterator.next();
                        if (!this.getPackageMetaData().getEClass("IfcPropertySingleValue").isSuperTypeOf(databaseSession.getEClassForOid(propertyOid))) continue;
                        HashMapVirtualObject property = this.getByOid(propertyOid);
                        String name = (String)property.get("Name");
                        HashMapWrappedVirtualObject value = (HashMapWrappedVirtualObject)property.get("NominalValue");
                        if (!propertiesObject.has(name)) continue;
                        Object queryPropertyValue = propertiesObject.get(name);
                        Object wrappedValue = value.eGet(value.eClass().getEStructuralFeature("wrappedValue"));
                        if (value.eClass().getName().equals("IfcBoolean")) {
                            Enumerator tristate = (Enumerator)wrappedValue;
                            if (!tristate.getName().toLowerCase().equals(queryPropertyValue.toString())) continue;
                            propertyKeysMatched.add(propertySetName + "___" + name);
                            continue;
                        }
                        if (!wrappedValue.equals(queryPropertyValue)) continue;
                        propertyKeysMatched.add(propertySetName + "___" + name);
                    }
                }
                if (propertyKeysMatched.size() != totalQueryProperties) {
                    this.currentObject = null;
                }
            }
        }
        this.processPossibleIncludes(this.currentObject, this.eClass, (CanInclude)this.getQueryPart());
        return false;
    }
}

