/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.database.queries;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import java.io.IOException;
import java.util.Iterator;
import org.bimserver.BimserverDatabaseException;
import org.bimserver.database.queries.QueryObjectProvider;
import org.bimserver.database.queries.QueryPartStackFrame;
import org.bimserver.database.queries.StackFrame;
import org.bimserver.database.queries.om.Query;
import org.bimserver.database.queries.om.QueryException;
import org.bimserver.database.queries.om.QueryPart;
import org.bimserver.shared.QueryContext;

public class QueryStackFrame
extends StackFrame {
    private Iterator<QueryPart> queryIterator;
    private QueryObjectProvider queryObjectProvider;
    private QueryContext reusable;

    public QueryStackFrame(QueryObjectProvider queryObjectProvider, QueryContext reusable) throws JsonParseException, JsonMappingException, IOException {
        this.queryObjectProvider = queryObjectProvider;
        this.reusable = reusable;
        Query query = queryObjectProvider.getQuery();
        this.queryIterator = query.getQueryParts().iterator();
    }

    @Override
    public boolean process() throws BimserverDatabaseException, QueryException {
        QueryPart next = this.queryIterator.next();
        this.queryObjectProvider.push(new QueryPartStackFrame(this.queryObjectProvider, next, this.reusable));
        return !this.queryIterator.hasNext();
    }
}

