/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.database.query.conditions;

import java.util.Set;
import org.bimserver.database.query.conditions.Condition;
import org.bimserver.database.query.conditions.LiteralCondition;
import org.bimserver.emf.IdEObject;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EStructuralFeature;

public class AttributeCondition
extends Condition {
    private final EAttribute attribute;
    private final LiteralCondition literal;

    public AttributeCondition(EAttribute attribute, LiteralCondition literal) {
        this.attribute = attribute;
        this.literal = literal;
    }

    public EAttribute getAttribute() {
        return this.attribute;
    }

    public LiteralCondition getLiteral() {
        return this.literal;
    }

    @Override
    public void getEClassRequirements(Set<EClass> classRequirements) {
        EClass eClass = this.attribute.getEContainingClass();
        classRequirements.add(eClass);
        for (EClassifier subClass : eClass.getEPackage().getEClassifiers()) {
            if (!(subClass instanceof EClass) || !eClass.isSuperTypeOf((EClass)subClass)) continue;
            classRequirements.add((EClass)subClass);
        }
    }

    @Override
    public boolean matches(IdEObject object) {
        if (!this.attribute.getEContainingClass().isSuperTypeOf(object.eClass())) {
            return false;
        }
        if (object.eGet((EStructuralFeature)this.attribute) == null && this.literal.getValue() == null) {
            return true;
        }
        if (object.eGet((EStructuralFeature)this.attribute) == null && this.literal.getValue() != null) {
            return false;
        }
        if (object.eGet((EStructuralFeature)this.attribute) != null && this.literal.getValue() == null) {
            return false;
        }
        return object.eGet((EStructuralFeature)this.attribute).equals(this.literal.getValue());
    }
}

