/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.endpoints;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.Maps;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.bimserver.endpoints.EndPoint;

public class EndPointManager {
    private final BiMap<Long, EndPoint> endPoints = Maps.synchronizedBiMap((BiMap)HashBiMap.create());
    private final AtomicLong idCounter = new AtomicLong(1L);

    public long register(EndPoint endPoint) {
        long id = this.idCounter.incrementAndGet();
        this.endPoints.forcePut((Object)id, (Object)endPoint);
        return id;
    }

    public void unregister(EndPoint endPoint) {
        this.endPoints.remove((Object)endPoint.getEndPointId());
        endPoint.cleanup();
    }

    public void unregister(long endPointId) {
        EndPoint endPoint = (EndPoint)this.endPoints.get((Object)endPointId);
        if (endPoint != null) {
            this.endPoints.remove((Object)endPointId);
            endPoint.cleanup();
        }
    }

    public EndPoint get(long endPointId) {
        return (EndPoint)this.endPoints.get((Object)endPointId);
    }

    public void clear() {
        for (Map.Entry entry : this.endPoints.entrySet()) {
            ((EndPoint)entry.getValue()).cleanup();
        }
        this.endPoints.clear();
    }
}

