/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.geometry;

import com.google.common.base.Joiner;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.bimserver.BimserverDatabaseException;
import org.bimserver.Color4f;
import org.bimserver.GenerateGeometryResult;
import org.bimserver.ObjectListener;
import org.bimserver.ObjectProviderProxy;
import org.bimserver.ProductDef;
import org.bimserver.Q;
import org.bimserver.Range;
import org.bimserver.database.DatabaseSession;
import org.bimserver.database.queries.QueryObjectProvider;
import org.bimserver.database.queries.om.Query;
import org.bimserver.database.queries.om.QueryPart;
import org.bimserver.geometry.Matrix;
import org.bimserver.geometry.ReportJob;
import org.bimserver.geometry.StreamingGeometryGenerator;
import org.bimserver.models.geometry.GeometryPackage;
import org.bimserver.plugins.PluginConfiguration;
import org.bimserver.plugins.PluginManagerInterface;
import org.bimserver.plugins.renderengine.EntityNotFoundException;
import org.bimserver.plugins.renderengine.RenderEngine;
import org.bimserver.plugins.renderengine.RenderEngineException;
import org.bimserver.plugins.renderengine.RenderEngineFilter;
import org.bimserver.plugins.renderengine.RenderEngineGeometry;
import org.bimserver.plugins.renderengine.RenderEngineInstance;
import org.bimserver.plugins.renderengine.RenderEngineModel;
import org.bimserver.plugins.renderengine.RenderEngineSettings;
import org.bimserver.plugins.serializers.ObjectProvider;
import org.bimserver.plugins.serializers.OidConvertingSerializer;
import org.bimserver.plugins.serializers.StreamingSerializer;
import org.bimserver.plugins.serializers.StreamingSerializerPlugin;
import org.bimserver.renderengine.RenderEnginePool;
import org.bimserver.shared.HashMapVirtualObject;
import org.bimserver.shared.HashMapWrappedVirtualObject;
import org.bimserver.shared.QueryContext;
import org.bimserver.shared.VirtualObject;
import org.bimserver.utils.GeometryUtils;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;

public class GeometryRunner
implements Runnable {
    private final StreamingGeometryGenerator streamingGeometryGenerator;
    private EClass eClass;
    private RenderEngineSettings renderEngineSettings;
    private RenderEngineFilter renderEngineFilter;
    private StreamingSerializerPlugin ifcSerializerPlugin;
    private GenerateGeometryResult generateGeometryResult;
    private ObjectProvider objectProvider;
    private QueryContext queryContext;
    private DatabaseSession databaseSession;
    private RenderEnginePool renderEnginePool;
    private boolean geometryReused;
    private Map<Long, ProductDef> map;
    private ReportJob job;
    private boolean reuseGeometry;
    private boolean writeOutputFiles = false;

    public GeometryRunner(StreamingGeometryGenerator streamingGeometryGenerator, EClass eClass, RenderEnginePool renderEnginePool, DatabaseSession databaseSession, RenderEngineSettings renderEngineSettings, ObjectProvider objectProvider, StreamingSerializerPlugin ifcSerializerPlugin, RenderEngineFilter renderEngineFilter, GenerateGeometryResult generateGeometryResult, QueryContext queryContext, Query originalQuery, boolean geometryReused, Map<Long, ProductDef> map, ReportJob job, boolean reuseGeometry) {
        this.streamingGeometryGenerator = streamingGeometryGenerator;
        this.eClass = eClass;
        this.renderEnginePool = renderEnginePool;
        this.databaseSession = databaseSession;
        this.renderEngineSettings = renderEngineSettings;
        this.objectProvider = objectProvider;
        this.ifcSerializerPlugin = ifcSerializerPlugin;
        this.renderEngineFilter = renderEngineFilter;
        this.generateGeometryResult = generateGeometryResult;
        this.queryContext = queryContext;
        this.geometryReused = geometryReused;
        this.map = map;
        this.job = job;
        this.reuseGeometry = reuseGeometry;
        this.job.setUsesMapping(map != null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        block70: {
            long start = System.nanoTime();
            this.job.setStartNanos(start);
            try {
                HashMapVirtualObject next = this.objectProvider.next();
                Query query = new Query("Double buffer query " + this.eClass.getName(), this.streamingGeometryGenerator.packageMetaData);
                QueryPart queryPart = query.createQueryPart();
                while (next != null) {
                    queryPart.addOid(next.getOid());
                    if (this.streamingGeometryGenerator.packageMetaData.getEClass("IfcProduct").isSuperTypeOf(next.eClass())) {
                        this.job.addObject(next.getOid(), next.eClass().getName());
                    }
                    next = this.objectProvider.next();
                }
                this.objectProvider = new QueryObjectProvider(this.databaseSession, this.streamingGeometryGenerator.bimServer, query, Collections.singleton(this.queryContext.getRoid()), this.streamingGeometryGenerator.packageMetaData);
                StreamingSerializer ifcSerializer = this.ifcSerializerPlugin.createSerializer(new PluginConfiguration());
                RenderEngine renderEngine = null;
                byte[] bytes = null;
                try {
                    final HashSet objects = new HashSet();
                    ObjectProviderProxy proxy = new ObjectProviderProxy(this.objectProvider, new ObjectListener(){

                        @Override
                        public void newObject(HashMapVirtualObject next) {
                            if (GeometryRunner.this.eClass.isSuperTypeOf(next.eClass()) && next.eGet(((GeometryRunner)GeometryRunner.this).streamingGeometryGenerator.representationFeature) != null) {
                                objects.add(next);
                            }
                        }
                    });
                    ifcSerializer.init((ObjectProvider)proxy, null, null, (PluginManagerInterface)this.streamingGeometryGenerator.bimServer.getPluginManager(), this.streamingGeometryGenerator.packageMetaData);
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    IOUtils.copy((InputStream)ifcSerializer.getInputStream(), (OutputStream)baos);
                    bytes = baos.toByteArray();
                    ByteArrayInputStream in = new ByteArrayInputStream(bytes);
                    HashMap<Integer, String> notFoundObjects = new HashMap<Integer, String>();
                    HashSet<Range> reusableGeometryData = new HashSet<Range>();
                    HashMap<Long, Q> productToData = new HashMap<Long, Q>();
                    try {
                        if (objects.isEmpty()) break block70;
                        renderEngine = this.renderEnginePool.borrowObject();
                        try (RenderEngineModel renderEngineModel = renderEngine.openModel((InputStream)in, (long)bytes.length);){
                            block71: {
                                renderEngineModel.setSettings(this.renderEngineSettings);
                                renderEngineModel.setFilter(this.renderEngineFilter);
                                try {
                                    renderEngineModel.generateGeneralGeometry();
                                }
                                catch (RenderEngineException e) {
                                    if (!(e.getCause() instanceof EOFException) || objects.isEmpty() || this.eClass.getName().equals("IfcAnnotation")) break block71;
                                    StreamingGeometryGenerator.LOGGER.error("Error in " + this.eClass.getName(), (Throwable)e);
                                }
                            }
                            OidConvertingSerializer oidConvertingSerializer = (OidConvertingSerializer)ifcSerializer;
                            Map oidToEid = oidConvertingSerializer.getOidToEid();
                            HashMap<Long, double[]> matrices = new HashMap<Long, double[]>();
                            for (HashMapVirtualObject ifcProduct : objects) {
                                if (!this.streamingGeometryGenerator.running) {
                                    return;
                                }
                                if (ifcProduct.get("GlobalId").equals("1sZn$z_i91bPOCQJOkOibU")) {
                                    System.out.println();
                                }
                                Integer expressId = (Integer)oidToEid.get(ifcProduct.getOid());
                                try {
                                    RenderEngineInstance renderEngineInstance = renderEngineModel.getInstanceFromExpressId(expressId.intValue());
                                    RenderEngineGeometry geometry = renderEngineInstance.generateGeometry();
                                    boolean translate = true;
                                    if (geometry == null || geometry.getNrIndices() <= 0) continue;
                                    HashMapVirtualObject geometryInfo = new HashMapVirtualObject(this.queryContext, GeometryPackage.eINSTANCE.getGeometryInfo());
                                    HashMapWrappedVirtualObject minBounds = new HashMapWrappedVirtualObject(GeometryPackage.eINSTANCE.getVector3f());
                                    HashMapWrappedVirtualObject maxBounds = new HashMapWrappedVirtualObject(GeometryPackage.eINSTANCE.getVector3f());
                                    minBounds.set("x", (Object)Double.POSITIVE_INFINITY);
                                    minBounds.set("y", (Object)Double.POSITIVE_INFINITY);
                                    minBounds.set("z", (Object)Double.POSITIVE_INFINITY);
                                    maxBounds.set("x", (Object)Double.NEGATIVE_INFINITY);
                                    maxBounds.set("y", (Object)Double.NEGATIVE_INFINITY);
                                    maxBounds.set("z", (Object)Double.NEGATIVE_INFINITY);
                                    geometryInfo.setAttribute((EStructuralFeature)GeometryPackage.eINSTANCE.getGeometryInfo_MinBounds(), (Object)minBounds);
                                    geometryInfo.setAttribute((EStructuralFeature)GeometryPackage.eINSTANCE.getGeometryInfo_MaxBounds(), (Object)maxBounds);
                                    HashMapWrappedVirtualObject minBoundsUntranslated = new HashMapWrappedVirtualObject(GeometryPackage.eINSTANCE.getVector3f());
                                    HashMapWrappedVirtualObject maxBoundsUntranslated = new HashMapWrappedVirtualObject(GeometryPackage.eINSTANCE.getVector3f());
                                    minBoundsUntranslated.set("x", (Object)Double.POSITIVE_INFINITY);
                                    minBoundsUntranslated.set("y", (Object)Double.POSITIVE_INFINITY);
                                    minBoundsUntranslated.set("z", (Object)Double.POSITIVE_INFINITY);
                                    maxBoundsUntranslated.set("x", (Object)Double.NEGATIVE_INFINITY);
                                    maxBoundsUntranslated.set("y", (Object)Double.NEGATIVE_INFINITY);
                                    maxBoundsUntranslated.set("z", (Object)Double.NEGATIVE_INFINITY);
                                    geometryInfo.setAttribute((EStructuralFeature)GeometryPackage.eINSTANCE.getGeometryInfo_MinBoundsUntranslated(), (Object)minBoundsUntranslated);
                                    geometryInfo.setAttribute((EStructuralFeature)GeometryPackage.eINSTANCE.getGeometryInfo_MaxBoundsUntranslated(), (Object)maxBoundsUntranslated);
                                    geometryInfo.setAttribute((EStructuralFeature)GeometryPackage.eINSTANCE.getGeometryInfo_Area(), (Object)renderEngineInstance.getArea());
                                    geometryInfo.setAttribute((EStructuralFeature)GeometryPackage.eINSTANCE.getGeometryInfo_Volume(), (Object)renderEngineInstance.getVolume());
                                    HashMapVirtualObject geometryData = new HashMapVirtualObject(this.queryContext, GeometryPackage.eINSTANCE.getGeometryData());
                                    int[] indices = geometry.getIndices();
                                    geometryData.setAttribute((EStructuralFeature)GeometryPackage.eINSTANCE.getGeometryData_Indices(), (Object)GeometryUtils.intArrayToByteArray((int[])indices));
                                    float[] vertices = geometry.getVertices();
                                    geometryData.setAttribute((EStructuralFeature)GeometryPackage.eINSTANCE.getGeometryData_Vertices(), (Object)GeometryUtils.floatArrayToByteArray((float[])vertices));
                                    geometryData.setAttribute((EStructuralFeature)GeometryPackage.eINSTANCE.getGeometryData_Normals(), (Object)GeometryUtils.floatArrayToByteArray((float[])geometry.getNormals()));
                                    geometryInfo.setAttribute((EStructuralFeature)GeometryPackage.eINSTANCE.getGeometryInfo_PrimitiveCount(), (Object)(indices.length / 3));
                                    this.job.setTrianglesGenerated(indices.length / 3);
                                    this.job.getReport().incrementTriangles(indices.length / 3);
                                    HashSet<Color4f> usedColors = new HashSet<Color4f>();
                                    if (geometry.getMaterialIndices() != null && geometry.getMaterialIndices().length > 0) {
                                        boolean hasMaterial = false;
                                        float[] vertex_colors = new float[vertices.length / 3 * 4];
                                        for (int i = 0; i < geometry.getMaterialIndices().length; ++i) {
                                            int c = geometry.getMaterialIndices()[i];
                                            for (int j = 0; j < 3; ++j) {
                                                int k = indices[i * 3 + j];
                                                if (c <= -1) continue;
                                                hasMaterial = true;
                                                Color4f color = new Color4f();
                                                for (int l = 0; l < 4; ++l) {
                                                    float val;
                                                    vertex_colors[4 * k + l] = val = geometry.getMaterials()[4 * c + l];
                                                    color.set(l, val);
                                                }
                                                usedColors.add(color);
                                            }
                                        }
                                        if (usedColors.size() == 1) {
                                            HashMapWrappedVirtualObject color = new HashMapWrappedVirtualObject(GeometryPackage.eINSTANCE.getVector4f());
                                            Color4f firstColor = (Color4f)usedColors.iterator().next();
                                            color.set("x", (Object)Float.valueOf(firstColor.getR()));
                                            color.set("y", (Object)Float.valueOf(firstColor.getG()));
                                            color.set("z", (Object)Float.valueOf(firstColor.getB()));
                                            color.set("w", (Object)Float.valueOf(firstColor.getA()));
                                            geometryData.setAttribute((EStructuralFeature)GeometryPackage.eINSTANCE.getGeometryData_Color(), (Object)color);
                                            hasMaterial = false;
                                        }
                                        if (hasMaterial) {
                                            geometryData.setAttribute((EStructuralFeature)GeometryPackage.eINSTANCE.getGeometryData_Materials(), (Object)GeometryUtils.floatArrayToByteArray((float[])vertex_colors));
                                        }
                                    }
                                    double[] productTranformationMatrix = new double[16];
                                    if (translate && renderEngineInstance.getTransformationMatrix() != null) {
                                        productTranformationMatrix = renderEngineInstance.getTransformationMatrix();
                                    } else {
                                        Matrix.setIdentityM((double[])productTranformationMatrix, (int)0);
                                    }
                                    geometryInfo.setReference((EStructuralFeature)GeometryPackage.eINSTANCE.getGeometryInfo_Data(), geometryData.getOid(), 0);
                                    long size = this.streamingGeometryGenerator.getSize((VirtualObject)geometryData);
                                    for (int i = 0; i < indices.length; ++i) {
                                        this.streamingGeometryGenerator.processExtends((VirtualObject)geometryInfo, productTranformationMatrix, vertices, indices[i] * 3, this.generateGeometryResult);
                                        this.streamingGeometryGenerator.processExtendsUntranslated((VirtualObject)geometryInfo, vertices, indices[i] * 3, this.generateGeometryResult);
                                    }
                                    double[] mibu = new double[]{(Double)minBoundsUntranslated.eGet((EStructuralFeature)GeometryPackage.eINSTANCE.getVector3f_X()), (Double)minBoundsUntranslated.eGet((EStructuralFeature)GeometryPackage.eINSTANCE.getVector3f_Y()), (Double)minBoundsUntranslated.eGet((EStructuralFeature)GeometryPackage.eINSTANCE.getVector3f_Z()), 1.0};
                                    double[] mabu = new double[]{(Double)maxBoundsUntranslated.eGet((EStructuralFeature)GeometryPackage.eINSTANCE.getVector3f_X()), (Double)maxBoundsUntranslated.eGet((EStructuralFeature)GeometryPackage.eINSTANCE.getVector3f_Y()), (Double)maxBoundsUntranslated.eGet((EStructuralFeature)GeometryPackage.eINSTANCE.getVector3f_Z()), 1.0};
                                    if (this.reuseGeometry) {
                                        int hash = this.streamingGeometryGenerator.hash((VirtualObject)geometryData);
                                        float[] firstVertex = new float[]{vertices[indices[0]], vertices[indices[0] + 1], vertices[indices[0] + 2]};
                                        float[] lastVertex = new float[]{vertices[indices[indices.length - 1] * 3], vertices[indices[indices.length - 1] * 3 + 1], vertices[indices[indices.length - 1] * 3 + 2]};
                                        Range range = new Range(firstVertex, lastVertex);
                                        if (this.streamingGeometryGenerator.hashes.containsKey(hash)) {
                                            geometryInfo.setReference((EStructuralFeature)GeometryPackage.eINSTANCE.getGeometryInfo_Data(), this.streamingGeometryGenerator.hashes.get(hash).longValue(), 0);
                                            this.streamingGeometryGenerator.bytesSavedByHash.addAndGet(size);
                                        } else if (this.geometryReused) {
                                            boolean found = false;
                                            if (!found) {
                                                range.setGeometryDataOid(geometryData.getOid());
                                                reusableGeometryData.add(range);
                                                geometryInfo.setAttribute((EStructuralFeature)GeometryPackage.eINSTANCE.getGeometryInfo_Area(), (Object)renderEngineInstance.getArea());
                                                geometryInfo.setAttribute((EStructuralFeature)GeometryPackage.eINSTANCE.getGeometryInfo_Volume(), (Object)renderEngineInstance.getVolume());
                                                geometryInfo.setAttribute((EStructuralFeature)GeometryPackage.eINSTANCE.getGeometryInfo_PrimitiveCount(), (Object)(indices.length / 3));
                                                productToData.put(ifcProduct.getOid(), new Q(geometryData.getOid(), renderEngineInstance.getArea(), renderEngineInstance.getVolume(), indices.length / 3, size, mibu, mabu));
                                                geometryData.save();
                                            }
                                        } else {
                                            if (this.geometryReused) {
                                                range.setGeometryDataOid(geometryData.getOid());
                                                reusableGeometryData.add(range);
                                                productToData.put(ifcProduct.getOid(), new Q(geometryData.getOid(), renderEngineInstance.getArea(), renderEngineInstance.getVolume(), indices.length / 3, size, mibu, mabu));
                                            }
                                            this.streamingGeometryGenerator.hashes.put(hash, geometryData.getOid());
                                            geometryData.save();
                                        }
                                    } else {
                                        geometryData.save();
                                    }
                                    this.calculateObb((VirtualObject)geometryInfo, productTranformationMatrix, indices, vertices, this.generateGeometryResult);
                                    this.streamingGeometryGenerator.setTransformationMatrix((VirtualObject)geometryInfo, productTranformationMatrix);
                                    matrices.put(ifcProduct.getOid(), productTranformationMatrix);
                                    geometryInfo.save();
                                    this.streamingGeometryGenerator.totalBytes.addAndGet(size);
                                    ifcProduct.setReference(this.streamingGeometryGenerator.geometryFeature, geometryInfo.getOid(), 0);
                                    ifcProduct.saveOverwrite();
                                }
                                catch (EntityNotFoundException e) {
                                    boolean ignoreNotFound = this.eClass.getName().equals("IfcAnnotation");
                                    if (ignoreNotFound) continue;
                                    notFoundObjects.put(expressId, ifcProduct.eClass().getName());
                                }
                                catch (BimserverDatabaseException | RenderEngineException e) {
                                    StreamingGeometryGenerator.LOGGER.error("", e);
                                }
                            }
                            if (this.geometryReused && this.map != null) {
                                long firstKey = this.map.keySet().iterator().next();
                                ProductDef masterProductDef = this.map.get(firstKey);
                                for (long key : this.map.keySet()) {
                                    if (key == firstKey) continue;
                                    ProductDef productDef = this.map.get(key);
                                    HashMapVirtualObject ifcProduct = productDef.getObject();
                                    Q q = (Q)productToData.get(productDef.getMasterOid());
                                    if (q == null) continue;
                                    HashMapVirtualObject geometryInfo = new HashMapVirtualObject(this.queryContext, GeometryPackage.eINSTANCE.getGeometryInfo());
                                    HashMapWrappedVirtualObject minBounds = new HashMapWrappedVirtualObject(GeometryPackage.eINSTANCE.getVector3f());
                                    HashMapWrappedVirtualObject maxBounds = new HashMapWrappedVirtualObject(GeometryPackage.eINSTANCE.getVector3f());
                                    double[] mibu = q.getMibu();
                                    double[] mabu = q.getMibu();
                                    double[] mibt = new double[4];
                                    double[] mabt = new double[4];
                                    Matrix.multiplyMV((double[])mibt, (int)0, (double[])productDef.getProductMatrix(), (int)0, (double[])mibu, (int)0);
                                    Matrix.multiplyMV((double[])mabt, (int)0, (double[])productDef.getProductMatrix(), (int)0, (double[])mabu, (int)0);
                                    minBounds.set("x", (Object)mibt[0]);
                                    minBounds.set("y", (Object)mibt[1]);
                                    minBounds.set("z", (Object)mibt[2]);
                                    maxBounds.set("x", (Object)mabt[0]);
                                    maxBounds.set("y", (Object)mabt[1]);
                                    maxBounds.set("z", (Object)mabt[2]);
                                    geometryInfo.setAttribute((EStructuralFeature)GeometryPackage.eINSTANCE.getGeometryInfo_MinBounds(), (Object)minBounds);
                                    geometryInfo.setAttribute((EStructuralFeature)GeometryPackage.eINSTANCE.getGeometryInfo_MaxBounds(), (Object)maxBounds);
                                    HashMapWrappedVirtualObject minBoundsUntranslated = new HashMapWrappedVirtualObject(GeometryPackage.eINSTANCE.getVector3f());
                                    HashMapWrappedVirtualObject maxBoundsUntranslated = new HashMapWrappedVirtualObject(GeometryPackage.eINSTANCE.getVector3f());
                                    minBoundsUntranslated.set("x", (Object)mibu[0]);
                                    minBoundsUntranslated.set("y", (Object)mibu[1]);
                                    minBoundsUntranslated.set("z", (Object)mibu[2]);
                                    maxBoundsUntranslated.set("x", (Object)mabu[0]);
                                    maxBoundsUntranslated.set("y", (Object)mabu[1]);
                                    maxBoundsUntranslated.set("z", (Object)mabu[2]);
                                    geometryInfo.setAttribute((EStructuralFeature)GeometryPackage.eINSTANCE.getGeometryInfo_MinBoundsUntranslated(), (Object)minBoundsUntranslated);
                                    geometryInfo.setAttribute((EStructuralFeature)GeometryPackage.eINSTANCE.getGeometryInfo_MaxBoundsUntranslated(), (Object)maxBoundsUntranslated);
                                    geometryInfo.setAttribute((EStructuralFeature)GeometryPackage.eINSTANCE.getGeometryInfo_Area(), (Object)q.getArea());
                                    geometryInfo.setAttribute((EStructuralFeature)GeometryPackage.eINSTANCE.getGeometryInfo_Volume(), (Object)q.getVolume());
                                    geometryInfo.setAttribute((EStructuralFeature)GeometryPackage.eINSTANCE.getGeometryInfo_PrimitiveCount(), (Object)q.getNrPrimitives());
                                    this.streamingGeometryGenerator.bytesSavedByMapping.addAndGet(q.getSize());
                                    this.streamingGeometryGenerator.totalBytes.addAndGet(q.getSize());
                                    double[] inverted = Matrix.identity();
                                    if (!Matrix.invertM((double[])inverted, (int)0, (double[])masterProductDef.getMappingMatrix(), (int)0)) {
                                        System.out.println("No inverse");
                                    }
                                    double[] finalMatrix = Matrix.identity();
                                    double[] totalTranformationMatrix = Matrix.identity();
                                    Matrix.multiplyMM((double[])finalMatrix, (int)0, (double[])productDef.getMappingMatrix(), (int)0, (double[])inverted, (int)0);
                                    Matrix.multiplyMM((double[])totalTranformationMatrix, (int)0, (double[])productDef.getProductMatrix(), (int)0, (double[])finalMatrix, (int)0);
                                    if (matrices.containsKey(ifcProduct.getOid()) && !Arrays.equals((double[])matrices.get(ifcProduct.getOid()), totalTranformationMatrix)) {
                                        System.out.println("Not the same " + ifcProduct.get("GlobalId"));
                                        Matrix.dump((double[])((double[])matrices.get(ifcProduct.getOid())));
                                        System.out.println();
                                        Matrix.dump((double[])totalTranformationMatrix);
                                    }
                                    geometryInfo.setReference((EStructuralFeature)GeometryPackage.eINSTANCE.getGeometryInfo_Data(), q.getOid(), 0);
                                    this.streamingGeometryGenerator.setTransformationMatrix((VirtualObject)geometryInfo, totalTranformationMatrix);
                                    geometryInfo.save();
                                    ifcProduct.setReference(this.streamingGeometryGenerator.geometryFeature, geometryInfo.getOid(), 0);
                                    ifcProduct.saveOverwrite();
                                }
                            }
                        }
                    }
                    finally {
                        if (renderEngine != null) {
                            this.renderEnginePool.returnObject(renderEngine);
                        }
                        try {
                            if (!notFoundObjects.isEmpty()) {
                                int debugId = this.writeDebugFile(bytes, false, notFoundObjects);
                                this.job.setException(new Exception("Missing objects in model (" + Joiner.on((String)", ").join(notFoundObjects.keySet()) + ")"), debugId);
                            } else if (this.writeOutputFiles) {
                                int debugId = this.writeDebugFile(bytes, false, null);
                                this.job.setDebugFile(debugId);
                            }
                            ((InputStream)in).close();
                        }
                        catch (Throwable debugId) {}
                        this.streamingGeometryGenerator.jobsDone.incrementAndGet();
                        this.streamingGeometryGenerator.updateProgress();
                    }
                }
                catch (Exception e) {
                    StreamingGeometryGenerator.LOGGER.error("", (Throwable)e);
                    int debugId = this.writeDebugFile(bytes, true, null);
                    this.job.setException(e, debugId);
                }
            }
            catch (Exception e) {
                StreamingGeometryGenerator.LOGGER.error("", (Throwable)e);
            }
        }
        long end = System.nanoTime();
        this.job.setEndNanos(end);
    }

    private synchronized int writeDebugFile(byte[] bytes, boolean error, Map<Integer, String> notFoundObjects) throws FileNotFoundException, IOException {
        boolean debug = true;
        if (debug) {
            Path folder;
            Path debugPath = this.streamingGeometryGenerator.bimServer.getHomeDir().resolve("debug");
            if (!Files.exists(debugPath, new LinkOption[0])) {
                Files.createDirectories(debugPath, new FileAttribute[0]);
            }
            if (!Files.exists(folder = debugPath.resolve(this.streamingGeometryGenerator.debugIdentifier), new LinkOption[0])) {
                Files.createDirectories(folder, new FileAttribute[0]);
            }
            String basefilenamename = "all";
            if (this.eClass != null) {
                basefilenamename = this.eClass.getName();
            }
            if (error) {
                basefilenamename = basefilenamename + "-error";
            }
            Path file = folder.resolve(basefilenamename + ".ifc");
            int i = 0;
            while (Files.exists(file, new LinkOption[0])) {
                file = folder.resolve(basefilenamename + "-" + i + ".ifc");
                ++i;
            }
            int debugFileId = this.job.getReport().addDebugFile(file.toString());
            StreamingGeometryGenerator.LOGGER.info("Writing debug file to " + file.toAbsolutePath().toString());
            FileUtils.writeByteArrayToFile((File)file.toFile(), (byte[])bytes);
            return debugFileId;
        }
        return -1;
    }

    private void calculateObb(VirtualObject geometryInfo, double[] tranformationMatrix, int[] indices, float[] vertices, GenerateGeometryResult generateGeometryResult2) {
    }
}

