/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.geometry;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.DoubleBuffer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.io.FileUtils;
import org.bimserver.BimServer;
import org.bimserver.BimserverDatabaseException;
import org.bimserver.GenerateGeometryResult;
import org.bimserver.GenericGeometryGenerator;
import org.bimserver.GeometryGeneratingException;
import org.bimserver.ProductDef;
import org.bimserver.database.DatabaseSession;
import org.bimserver.database.OldQuery;
import org.bimserver.database.actions.ProgressListener;
import org.bimserver.database.queries.QueryObjectProvider;
import org.bimserver.database.queries.om.Include;
import org.bimserver.database.queries.om.JsonQueryObjectModelConverter;
import org.bimserver.database.queries.om.Query;
import org.bimserver.database.queries.om.QueryException;
import org.bimserver.database.queries.om.QueryPart;
import org.bimserver.emf.PackageMetaData;
import org.bimserver.emf.Schema;
import org.bimserver.geometry.GeometryGenerationReport;
import org.bimserver.geometry.GeometryRunner;
import org.bimserver.geometry.Matrix;
import org.bimserver.geometry.ReportJob;
import org.bimserver.geometry.Vector;
import org.bimserver.models.geometry.GeometryPackage;
import org.bimserver.models.store.RenderEnginePluginConfiguration;
import org.bimserver.models.store.User;
import org.bimserver.models.store.UserSettings;
import org.bimserver.plugins.PluginConfiguration;
import org.bimserver.plugins.renderengine.IndexFormat;
import org.bimserver.plugins.renderengine.Precision;
import org.bimserver.plugins.renderengine.RenderEngine;
import org.bimserver.plugins.renderengine.RenderEngineFilter;
import org.bimserver.plugins.renderengine.RenderEngineSettings;
import org.bimserver.plugins.serializers.StreamingSerializerPlugin;
import org.bimserver.renderengine.RenderEnginePool;
import org.bimserver.shared.HashMapVirtualObject;
import org.bimserver.shared.HashMapWrappedVirtualObject;
import org.bimserver.shared.QueryContext;
import org.bimserver.shared.VirtualObject;
import org.bimserver.shared.exceptions.UserException;
import org.bimserver.utils.Formatters;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamingGeometryGenerator
extends GenericGeometryGenerator {
    static final Logger LOGGER = LoggerFactory.getLogger(StreamingGeometryGenerator.class);
    final BimServer bimServer;
    final Map<Integer, Long> hashes = new ConcurrentHashMap<Integer, Long>();
    private EClass productClass;
    EStructuralFeature geometryFeature;
    EStructuralFeature representationFeature;
    PackageMetaData packageMetaData;
    AtomicLong bytesSavedByHash = new AtomicLong();
    private AtomicLong bytesSavedByTransformation = new AtomicLong();
    AtomicLong bytesSavedByMapping = new AtomicLong();
    AtomicLong totalBytes = new AtomicLong();
    AtomicInteger jobsDone = new AtomicInteger();
    private AtomicInteger jobsTotal = new AtomicInteger();
    private ProgressListener progressListener;
    private volatile boolean allJobsPushed;
    private int maxObjectsPerFile = 10;
    volatile boolean running = true;
    String debugIdentifier;
    private EStructuralFeature representationsFeature;
    private EStructuralFeature itemsFeature;
    private EStructuralFeature mappingSourceFeature;
    private String renderEngineName;
    private Long eoid = -1L;
    private GeometryGenerationReport report;
    private boolean reuseGeometry;
    private boolean optimizeMappedItems;

    public StreamingGeometryGenerator(BimServer bimServer, ProgressListener progressListener, Long eoid, GeometryGenerationReport report) {
        this.bimServer = bimServer;
        this.progressListener = progressListener;
        this.eoid = eoid;
        this.report = report;
    }

    void updateProgress() {
        if (this.allJobsPushed && this.progressListener != null) {
            this.progressListener.updateProgress("Generating geometry...", (int)(100.0 * (double)this.jobsDone.get() / (double)this.jobsTotal.get()));
        }
    }

    public GenerateGeometryResult generateGeometry(long uoid, DatabaseSession databaseSession, QueryContext queryContext) throws BimserverDatabaseException, GeometryGeneratingException {
        GenerateGeometryResult generateGeometryResult = new GenerateGeometryResult();
        this.packageMetaData = queryContext.getPackageMetaData();
        this.productClass = this.packageMetaData.getEClass("IfcProduct");
        this.geometryFeature = this.productClass.getEStructuralFeature("geometry");
        this.representationFeature = this.productClass.getEStructuralFeature("Representation");
        this.representationsFeature = this.packageMetaData.getEClass("IfcProductDefinitionShape").getEStructuralFeature("Representations");
        this.itemsFeature = this.packageMetaData.getEClass("IfcShapeRepresentation").getEStructuralFeature("Items");
        this.mappingSourceFeature = this.packageMetaData.getEClass("IfcMappedItem").getEStructuralFeature("MappingSource");
        GregorianCalendar now = new GregorianCalendar();
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd-HH-mm-ss");
        this.debugIdentifier = dateFormat.format(now.getTime());
        long start = System.nanoTime();
        String pluginName = "";
        if (queryContext.getPackageMetaData().getSchema() == Schema.IFC4) {
            pluginName = "org.bimserver.ifc.step.serializer.Ifc4StepStreamingSerializerPlugin";
        } else if (queryContext.getPackageMetaData().getSchema() == Schema.IFC2X3TC1) {
            pluginName = "org.bimserver.ifc.step.serializer.Ifc2x3tc1StepStreamingSerializerPlugin";
        } else {
            throw new GeometryGeneratingException("Unknown schema " + queryContext.getPackageMetaData().getSchema());
        }
        this.reuseGeometry = this.bimServer.getServerSettingsCache().getServerSettings().isReuseGeometry();
        this.optimizeMappedItems = this.bimServer.getServerSettingsCache().getServerSettings().isOptimizeMappedItems();
        this.report.setStart(new GregorianCalendar());
        this.report.setIfcSchema(queryContext.getPackageMetaData().getSchema());
        this.report.setMaxPerFile(this.maxObjectsPerFile);
        this.report.setUseMappingOptimization(this.optimizeMappedItems);
        this.report.setReuseGeometry(this.reuseGeometry);
        try {
            StreamingSerializerPlugin ifcSerializerPlugin = (StreamingSerializerPlugin)this.bimServer.getPluginManager().getPlugin(pluginName, true);
            if (ifcSerializerPlugin == null) {
                throw new UserException("No IFC serializer found");
            }
            User user = (User)databaseSession.get(uoid, OldQuery.getDefault());
            UserSettings userSettings = user.getUserSettings();
            this.report.setUserName(user.getName());
            this.report.setUserUserName(user.getUsername());
            RenderEnginePluginConfiguration renderEngine = null;
            renderEngine = this.eoid != -1L ? (RenderEnginePluginConfiguration)databaseSession.get(this.eoid, OldQuery.getDefault()) : userSettings.getDefaultRenderEngine();
            if (renderEngine == null) {
                throw new UserException("No default render engine has been selected for this user");
            }
            this.renderEngineName = renderEngine.getName();
            int availableProcessors = Runtime.getRuntime().availableProcessors();
            this.report.setAvailableProcessors(availableProcessors);
            int maxSimultanousThreads = Math.min(this.bimServer.getServerSettingsCache().getServerSettings().getRenderEngineProcesses(), availableProcessors);
            if (maxSimultanousThreads < 1) {
                maxSimultanousThreads = 1;
            }
            RenderEngineSettings settings = new RenderEngineSettings();
            settings.setPrecision(Precision.SINGLE);
            settings.setIndexFormat(IndexFormat.AUTO_DETECT);
            settings.setGenerateNormals(true);
            settings.setGenerateTriangles(true);
            settings.setGenerateWireFrame(false);
            RenderEngineFilter renderEngineFilter = new RenderEngineFilter();
            RenderEnginePool renderEnginePool = this.bimServer.getRenderEnginePools().getRenderEnginePool(this.packageMetaData.getSchema(), renderEngine.getPluginDescriptor().getPluginClassName(), new PluginConfiguration(renderEngine.getSettings()));
            this.report.setRenderEngineName(renderEngine.getName());
            this.report.setRenderEnginePluginVersion(renderEngine.getPluginDescriptor().getPluginBundleVersion().getVersion());
            try (RenderEngine engine = renderEnginePool.borrowObject();){
                this.report.setRenderEngineVersion(engine.getVersion());
            }
            ThreadPoolExecutor executor = new ThreadPoolExecutor(maxSimultanousThreads, maxSimultanousThreads, 24L, TimeUnit.HOURS, new ArrayBlockingQueue<Runnable>(10000000));
            JsonQueryObjectModelConverter jsonQueryObjectModelConverter = new JsonQueryObjectModelConverter(this.packageMetaData);
            String queryNameSpace = "validifc";
            if (this.packageMetaData.getSchema() == Schema.IFC4) {
                queryNameSpace = "ifc4stdlib";
            }
            Include objectPlacement = jsonQueryObjectModelConverter.getDefineFromFile(queryNameSpace + ":ObjectPlacement");
            objectPlacement.makeDirectRecursive(new HashSet());
            Set classes = null;
            classes = queryContext.getOidCounters() != null ? queryContext.getOidCounters().keySet() : this.packageMetaData.getEClasses();
            for (EClass eClass : classes) {
                Object representations;
                if (!this.packageMetaData.getEClass("IfcProduct").isSuperTypeOf(eClass)) continue;
                Query query2 = new Query(eClass.getName() + "Main query", this.packageMetaData);
                QueryPart queryPart2 = query2.createQueryPart();
                queryPart2.addType(eClass, false);
                Include representationInclude = queryPart2.createInclude();
                representationInclude.addType(eClass, false);
                representationInclude.addFieldDirect("Representation");
                Include representationsInclude = representationInclude.createInclude();
                representationsInclude.addType(this.packageMetaData.getEClass("IfcProductRepresentation"), true);
                representationsInclude.addFieldDirect("Representations");
                Include itemsInclude = representationsInclude.createInclude();
                itemsInclude.addType(this.packageMetaData.getEClass("IfcShapeRepresentation"), false);
                itemsInclude.addFieldDirect("Items");
                Include mappingSourceInclude = itemsInclude.createInclude();
                mappingSourceInclude.addType(this.packageMetaData.getEClass("IfcMappedItem"), false);
                mappingSourceInclude.addFieldDirect("MappingSource");
                mappingSourceInclude.addFieldDirect("MappingTarget");
                Include representationMap = mappingSourceInclude.createInclude();
                representationMap.addType(this.packageMetaData.getEClass("IfcRepresentationMap"), false);
                Include targetInclude = mappingSourceInclude.createInclude();
                targetInclude.addType(this.packageMetaData.getEClass("IfcCartesianTransformationOperator3D"), false);
                targetInclude.addFieldDirect("Axis1");
                targetInclude.addFieldDirect("Axis2");
                targetInclude.addFieldDirect("Axis3");
                targetInclude.addFieldDirect("LocalOrigin");
                queryPart2.addInclude(objectPlacement);
                HashMap representationMapToProduct = new HashMap();
                QueryObjectProvider queryObjectProvider2 = new QueryObjectProvider(databaseSession, this.bimServer, query2, Collections.singleton(queryContext.getRoid()), this.packageMetaData);
                HashMapVirtualObject next = queryObjectProvider2.next();
                while (next != null) {
                    HashMapVirtualObject representation;
                    if (next.eClass() == eClass && (representation = next.getDirectFeature(this.representationFeature)) != null && (representations = representation.getDirectListFeature(this.representationsFeature)) != null) {
                        Iterator iterator = representations.iterator();
                        while (iterator.hasNext()) {
                            HashMapVirtualObject representationItem = (HashMapVirtualObject)iterator.next();
                            if (!representationItem.get("RepresentationIdentifier").equals("Body")) continue;
                            List items = representationItem.getDirectListFeature(this.itemsFeature);
                            for (HashMapVirtualObject item : items) {
                                HashMapVirtualObject mappingSource;
                                HashMapVirtualObject placement;
                                this.report.addRepresentationItem(item.eClass().getName());
                                HashMapVirtualObject mappingTarget = item.getDirectFeature((EStructuralFeature)this.packageMetaData.getEReference("IfcMappedItem", "MappingTarget"));
                                Object mappingMatrix = Matrix.identity();
                                double[] productMatrix = Matrix.identity();
                                if (mappingTarget != null) {
                                    List list;
                                    HashMapVirtualObject axis1 = mappingTarget.getDirectFeature((EStructuralFeature)this.packageMetaData.getEReference("IfcCartesianTransformationOperator", "Axis1"));
                                    HashMapVirtualObject axis2 = mappingTarget.getDirectFeature((EStructuralFeature)this.packageMetaData.getEReference("IfcCartesianTransformationOperator", "Axis2"));
                                    HashMapVirtualObject axis3 = mappingTarget.getDirectFeature((EStructuralFeature)this.packageMetaData.getEReference("IfcCartesianTransformationOperator", "Axis3"));
                                    HashMapVirtualObject localOrigin = mappingTarget.getDirectFeature((EStructuralFeature)this.packageMetaData.getEReference("IfcCartesianTransformationOperator", "LocalOrigin"));
                                    double[] a1 = null;
                                    double[] a2 = null;
                                    double[] a3 = null;
                                    if (axis3 != null) {
                                        list = (List)axis3.get("DirectionRatios");
                                        a3 = new double[]{(Double)list.get(0), (Double)list.get(1), (Double)list.get(2)};
                                    } else {
                                        a3 = new double[]{0.0, 0.0, 1.0, 1.0};
                                        Vector.normalize((double[])a3);
                                    }
                                    if (axis1 != null) {
                                        list = (List)axis1.get("DirectionRatios");
                                        a1 = new double[]{(Double)list.get(0), (Double)list.get(1), (Double)list.get(2)};
                                        Vector.normalize((double[])a1);
                                    } else {
                                        a1 = new double[]{1.0, 0.0, 0.0, 1.0};
                                    }
                                    double[] xVec = Vector.scalarProduct((double)Vector.dot((double[])a1, (double[])a3), (double[])a3);
                                    double[] xAxis = Vector.subtract((double[])a1, (double[])xVec);
                                    Vector.normalize((double[])xAxis);
                                    if (axis2 != null) {
                                        List list2 = (List)axis2.get("DirectionRatios");
                                        a2 = new double[]{(Double)list2.get(0), (Double)list2.get(1), (Double)list2.get(2)};
                                        Vector.normalize((double[])a2);
                                    } else {
                                        a2 = new double[]{0.0, 1.0, 0.0, 1.0};
                                    }
                                    double[] tmp = Vector.scalarProduct((double)Vector.dot((double[])a2, (double[])a3), (double[])a3);
                                    double[] yAxis = Vector.subtract((double[])a2, (double[])tmp);
                                    tmp = Vector.scalarProduct((double)Vector.dot((double[])a2, (double[])xAxis), (double[])xAxis);
                                    yAxis = Vector.subtract((double[])yAxis, (double[])tmp);
                                    Vector.normalize((double[])yAxis);
                                    a2 = yAxis;
                                    a1 = xAxis;
                                    List t = (List)localOrigin.get("Coordinates");
                                    mappingMatrix = new double[]{a1[0], a1[1], a1[2], 0.0, a2[0], a2[1], a2[2], 0.0, a3[0], a3[1], a3[2], 0.0, (Double)t.get(0), (Double)t.get(1), (Double)t.get(2), 1.0};
                                }
                                if ((placement = next.getDirectFeature((EStructuralFeature)this.packageMetaData.getEReference("IfcProduct", "ObjectPlacement"))) != null) {
                                    productMatrix = this.placementToMatrix(placement);
                                }
                                if ((mappingSource = item.getDirectFeature(this.mappingSourceFeature)) == null) continue;
                                LinkedHashMap<Long, ProductDef> map = (LinkedHashMap<Long, ProductDef>)representationMapToProduct.get(mappingSource.getOid());
                                if (map == null) {
                                    map = new LinkedHashMap<Long, ProductDef>();
                                    representationMapToProduct.put(mappingSource.getOid(), map);
                                }
                                ProductDef pd = new ProductDef(next.getOid());
                                pd.setObject(next);
                                pd.setProductMatrix(productMatrix);
                                pd.setMappingMatrix((double[])mappingMatrix);
                                map.put(next.getOid(), pd);
                            }
                        }
                    }
                    next = queryObjectProvider2.next();
                }
                HashSet<Long> done = new HashSet<Long>();
                representations = representationMapToProduct.keySet().iterator();
                while (representations.hasNext()) {
                    Long repMapId = (Long)representations.next();
                    Map map = (Map)representationMapToProduct.get(repMapId);
                    if (map.size() <= 1) continue;
                    Query query = new Query("Reuse query " + eClass.getName(), this.packageMetaData);
                    QueryPart queryPart = query.createQueryPart();
                    queryPart.addType(eClass, false);
                    long masterOid = ((ProductDef)map.values().iterator().next()).getOid();
                    for (Object pd : map.values()) {
                        done.add(((ProductDef)pd).getOid());
                        if (!this.optimizeMappedItems) {
                            queryPart.addOid(((ProductDef)pd).getOid());
                            continue;
                        }
                        ((ProductDef)pd).setMasterOid(masterOid);
                    }
                    if (this.optimizeMappedItems) {
                        queryPart.addOid(masterOid);
                    }
                    LOGGER.debug("Running " + map.size() + " objects in one batch because of reused geometry " + eClass.getName());
                    this.processX(databaseSession, queryContext, generateGeometryResult, ifcSerializerPlugin, settings, renderEngineFilter, renderEnginePool, executor, eClass, query, queryPart, true, map, map.size());
                }
                Query query3 = new Query("Remaining " + eClass.getName(), this.packageMetaData);
                QueryPart queryPart3 = query3.createQueryPart();
                queryPart3.addType(eClass, false);
                Include include3 = queryPart3.createInclude();
                include3.addType(eClass, false);
                include3.addFieldDirect("Representation");
                Include rInclude = include3.createInclude();
                rInclude.addType(this.packageMetaData.getEClass("IfcProductRepresentation"), false);
                rInclude.addFieldDirect("Representations");
                Include representationsInclude2 = rInclude.createInclude();
                representationsInclude2.addType(this.packageMetaData.getEClass("IfcShapeModel"), false);
                queryObjectProvider2 = new QueryObjectProvider(databaseSession, this.bimServer, query3, Collections.singleton(queryContext.getRoid()), this.packageMetaData);
                next = queryObjectProvider2.next();
                while (next != null) {
                    HashMapVirtualObject representation;
                    if (next.eClass() == eClass && !done.contains(next.getOid()) && (representation = next.getDirectFeature(this.representationFeature)) != null) {
                        List list = representation.getDirectListFeature((EStructuralFeature)this.packageMetaData.getEReference("IfcProductRepresentation", "Representations"));
                        boolean goForIt = false;
                        if (list != null) {
                            Object pd;
                            pd = list.iterator();
                            while (pd.hasNext()) {
                                HashMapVirtualObject o = (HashMapVirtualObject)pd.next();
                                if (!o.get("RepresentationIdentifier").equals("Body")) continue;
                                goForIt = true;
                            }
                        }
                        if (goForIt) {
                            Query query = new Query("Main " + eClass.getName(), this.packageMetaData);
                            QueryPart queryPart = query.createQueryPart();
                            queryPart.addType(eClass, false);
                            int x = 1;
                            queryPart.addOid(next.getOid());
                            while (next != null && x < this.maxObjectsPerFile) {
                                next = queryObjectProvider2.next();
                                if (next == null || next.eClass() != eClass || done.contains(next.getOid()) || (representation = next.getDirectFeature(this.representationFeature)) == null) continue;
                                list = representation.getDirectListFeature((EStructuralFeature)this.packageMetaData.getEReference("IfcProductRepresentation", "Representations"));
                                boolean goForIt2 = false;
                                if (list != null) {
                                    for (HashMapVirtualObject o : list) {
                                        if (!o.get("RepresentationIdentifier").equals("Body")) continue;
                                        goForIt2 = true;
                                    }
                                }
                                if (!goForIt2) continue;
                                queryPart.addOid(next.getOid());
                                ++x;
                            }
                            this.processX(databaseSession, queryContext, generateGeometryResult, ifcSerializerPlugin, settings, renderEngineFilter, renderEnginePool, executor, eClass, query, queryPart, false, null, x);
                        }
                    }
                    next = queryObjectProvider2.next();
                }
            }
            this.allJobsPushed = true;
            executor.shutdown();
            executor.awaitTermination(24L, TimeUnit.HOURS);
            long end = System.nanoTime();
            long total = this.totalBytes.get() - (this.bytesSavedByHash.get() + this.bytesSavedByTransformation.get() + this.bytesSavedByMapping.get());
            LOGGER.info("Rendertime: " + Formatters.nanosToString((long)(end - start)) + ", Reused (by hash): " + Formatters.bytesToString((long)this.bytesSavedByHash.get()) + ", Reused (by transformation): " + Formatters.bytesToString((long)this.bytesSavedByTransformation.get()) + ", Reused (by mapping): " + Formatters.bytesToString((long)this.bytesSavedByMapping.get()) + ", Total: " + Formatters.bytesToString((long)this.totalBytes.get()) + ", Final: " + Formatters.bytesToString((long)total));
        }
        catch (Exception e) {
            this.running = false;
            LOGGER.error("", (Throwable)e);
            this.report.setEnd(new GregorianCalendar());
            throw new GeometryGeneratingException(e);
        }
        this.report.setEnd(new GregorianCalendar());
        try {
            this.writeDebugFile();
        }
        catch (IOException e) {
            LOGGER.debug("", (Throwable)e);
        }
        return generateGeometryResult;
    }

    private void writeDebugFile() throws IOException {
        Path folder;
        Path debugPath = this.bimServer.getHomeDir().resolve("debug");
        if (!Files.exists(debugPath, new LinkOption[0])) {
            Files.createDirectories(debugPath, new FileAttribute[0]);
        }
        if (!Files.exists(folder = debugPath.resolve(this.debugIdentifier), new LinkOption[0])) {
            Files.createDirectories(folder, new FileAttribute[0]);
        }
        Path file = folder.resolve("generationreport.html");
        FileUtils.writeStringToFile((File)file.toFile(), (String)this.report.toHtml());
    }

    public double[] placement3DToMatrix(HashMapVirtualObject ifcAxis2Placement3D) {
        EReference refDirectionFeature = this.packageMetaData.getEReference("IfcAxis2Placement3D", "RefDirection");
        HashMapVirtualObject location = ifcAxis2Placement3D.getDirectFeature((EStructuralFeature)this.packageMetaData.getEReference("IfcPlacement", "Location"));
        if (ifcAxis2Placement3D.getDirectFeature((EStructuralFeature)this.packageMetaData.getEReference("IfcAxis2Placement3D", "Axis")) != null && ifcAxis2Placement3D.getDirectFeature((EStructuralFeature)refDirectionFeature) != null) {
            HashMapVirtualObject axis = ifcAxis2Placement3D.getDirectFeature((EStructuralFeature)this.packageMetaData.getEReference("IfcAxis2Placement3D", "Axis"));
            HashMapVirtualObject direction = ifcAxis2Placement3D.getDirectFeature((EStructuralFeature)refDirectionFeature);
            List axisDirectionRatios = (List)axis.get("DirectionRatios");
            List directionDirectionRatios = (List)direction.get("DirectionRatios");
            List locationCoordinates = (List)location.get("Coordinates");
            double[] cross = Vector.crossProduct((double[])new double[]{(Double)axisDirectionRatios.get(0), (Double)axisDirectionRatios.get(1), (Double)axisDirectionRatios.get(2), 1.0}, (double[])new double[]{(Double)directionDirectionRatios.get(0), (Double)directionDirectionRatios.get(1), (Double)directionDirectionRatios.get(2), 1.0});
            return new double[]{(Double)directionDirectionRatios.get(0), (Double)directionDirectionRatios.get(1), (Double)directionDirectionRatios.get(2), 0.0, cross[0], cross[1], cross[2], 0.0, (Double)axisDirectionRatios.get(0), (Double)axisDirectionRatios.get(1), (Double)axisDirectionRatios.get(2), 0.0, (Double)locationCoordinates.get(0), (Double)locationCoordinates.get(1), (Double)locationCoordinates.get(2), 1.0};
        }
        if (location != null) {
            List locationCoordinates = (List)location.get("Coordinates");
            return new double[]{1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, (Double)locationCoordinates.get(0), (Double)locationCoordinates.get(1), (Double)locationCoordinates.get(2), 1.0};
        }
        return Matrix.identity();
    }

    private double[] placementToMatrix(HashMapVirtualObject placement) {
        HashMapVirtualObject relativePlacement;
        HashMapVirtualObject placementRelTo = placement.getDirectFeature((EStructuralFeature)this.packageMetaData.getEReference("IfcLocalPlacement", "PlacementRelTo"));
        double[] matrix = Matrix.identity();
        if (placement.eClass().getName().equals("IfcLocalPlacement") && (relativePlacement = placement.getDirectFeature((EStructuralFeature)this.packageMetaData.getEReference("IfcLocalPlacement", "RelativePlacement"))) != null && relativePlacement.eClass().getName().equals("IfcAxis2Placement3D")) {
            matrix = this.placement3DToMatrix(relativePlacement);
        }
        if (placementRelTo != null) {
            double[] baseMatrix = this.placementToMatrix(placementRelTo);
            double[] rhs = matrix;
            matrix = Matrix.identity();
            Matrix.multiplyMM((double[])matrix, (int)0, (double[])baseMatrix, (int)0, (double[])rhs, (int)0);
        }
        return matrix;
    }

    private void processX(DatabaseSession databaseSession, QueryContext queryContext, GenerateGeometryResult generateGeometryResult, StreamingSerializerPlugin ifcSerializerPlugin, RenderEngineSettings settings, RenderEngineFilter renderEngineFilter, RenderEnginePool renderEnginePool, ThreadPoolExecutor executor, EClass eClass, Query query, QueryPart queryPart, boolean geometryReused, Map<Long, ProductDef> map, int nrObjects) throws QueryException, IOException {
        JsonQueryObjectModelConverter jsonQueryObjectModelConverter = new JsonQueryObjectModelConverter(this.packageMetaData);
        String queryNameSpace = "validifc";
        if (this.packageMetaData.getSchema() == Schema.IFC4) {
            queryNameSpace = "ifc4stdlib";
        }
        if (eClass.getName().equals("IfcAnnotation")) {
            queryPart.addInclude(jsonQueryObjectModelConverter.getDefineFromFile(queryNameSpace + ":IfcAnnotationContainedInStructure"));
        } else {
            queryPart.addInclude(jsonQueryObjectModelConverter.getDefineFromFile(queryNameSpace + ":ContainedInStructure"));
        }
        if (this.packageMetaData.getSchema() == Schema.IFC4) {
            queryPart.addInclude(jsonQueryObjectModelConverter.getDefineFromFile(queryNameSpace + ":IsTypedBy"));
        }
        queryPart.addInclude(jsonQueryObjectModelConverter.getDefineFromFile(queryNameSpace + ":Decomposes"));
        queryPart.addInclude(jsonQueryObjectModelConverter.getDefineFromFile(queryNameSpace + ":OwnerHistory"));
        Include representationInclude = jsonQueryObjectModelConverter.getDefineFromFile(queryNameSpace + ":Representation");
        queryPart.addInclude(representationInclude);
        Include objectPlacement = jsonQueryObjectModelConverter.getDefineFromFile(queryNameSpace + ":ObjectPlacement");
        queryPart.addInclude(objectPlacement);
        if (this.packageMetaData.getEClass("IfcElement").isSuperTypeOf(eClass)) {
            Include openingsInclude = queryPart.createInclude();
            openingsInclude.addType(this.packageMetaData.getEClass(eClass.getName()), false);
            openingsInclude.addField("HasOpenings");
            Include hasOpenings = openingsInclude.createInclude();
            hasOpenings.addType(this.packageMetaData.getEClass("IfcRelVoidsElement"), false);
            hasOpenings.addField("RelatedOpeningElement");
            hasOpenings.addInclude(representationInclude);
            hasOpenings.addInclude(objectPlacement);
        }
        QueryObjectProvider queryObjectProvider = new QueryObjectProvider(databaseSession, this.bimServer, query, Collections.singleton(queryContext.getRoid()), this.packageMetaData);
        ReportJob job = this.report.newJob(eClass.getName(), nrObjects);
        GeometryRunner runner = new GeometryRunner(this, eClass, renderEnginePool, databaseSession, settings, queryObjectProvider, ifcSerializerPlugin, renderEngineFilter, generateGeometryResult, queryContext, query, geometryReused, map, job, this.reuseGeometry);
        executor.submit(runner);
        this.jobsTotal.incrementAndGet();
    }

    long getSize(VirtualObject geometryData) {
        long size = 0L;
        if (geometryData.has("indices")) {
            size += (long)((byte[])geometryData.get("indices")).length;
        }
        if (geometryData.has("vertices")) {
            size += (long)((byte[])geometryData.get("vertices")).length;
        }
        if (geometryData.has("normals")) {
            size += (long)((byte[])geometryData.get("normals")).length;
        }
        if (geometryData.has("materialIndices")) {
            size += (long)((byte[])geometryData.get("materialIndices")).length;
        }
        if (geometryData.has("materials")) {
            size += (long)((byte[])geometryData.get("materials")).length;
        }
        return size;
    }

    int hash(VirtualObject geometryData) {
        int hashCode = 0;
        if (geometryData.has("indices")) {
            hashCode += Arrays.hashCode((byte[])geometryData.get("indices"));
        }
        if (geometryData.has("vertices")) {
            hashCode += Arrays.hashCode((byte[])geometryData.get("vertices"));
        }
        if (geometryData.has("normals")) {
            hashCode += Arrays.hashCode((byte[])geometryData.get("normals"));
        }
        if (geometryData.has("materialIndices")) {
            hashCode += Arrays.hashCode((byte[])geometryData.get("materialIndices"));
        }
        if (geometryData.has("materials")) {
            hashCode += Arrays.hashCode((byte[])geometryData.get("materials"));
        }
        if (geometryData.has("color")) {
            hashCode += ((HashMapWrappedVirtualObject)geometryData.get("color")).hashCode();
        }
        return hashCode;
    }

    void processExtendsUntranslated(VirtualObject geometryInfo, float[] vertices, int index, GenerateGeometryResult generateGeometryResult2) throws BimserverDatabaseException {
        double x = vertices[index];
        double y = vertices[index + 1];
        double z = vertices[index + 2];
        HashMapWrappedVirtualObject minBounds = (HashMapWrappedVirtualObject)geometryInfo.eGet((EStructuralFeature)GeometryPackage.eINSTANCE.getGeometryInfo_MinBoundsUntranslated());
        HashMapWrappedVirtualObject maxBounds = (HashMapWrappedVirtualObject)geometryInfo.eGet((EStructuralFeature)GeometryPackage.eINSTANCE.getGeometryInfo_MaxBoundsUntranslated());
        minBounds.set("x", (Object)Math.min(x, (Double)minBounds.eGet("x")));
        minBounds.set("y", (Object)Math.min(y, (Double)minBounds.eGet("y")));
        minBounds.set("z", (Object)Math.min(z, (Double)minBounds.eGet("z")));
        maxBounds.set("x", (Object)Math.max(x, (Double)maxBounds.eGet("x")));
        maxBounds.set("y", (Object)Math.max(y, (Double)maxBounds.eGet("y")));
        maxBounds.set("z", (Object)Math.max(z, (Double)maxBounds.eGet("z")));
    }

    void processExtends(VirtualObject geometryInfo, double[] transformationMatrix, float[] vertices, int index, GenerateGeometryResult generateGeometryResult) throws BimserverDatabaseException {
        double x = vertices[index];
        double y = vertices[index + 1];
        double z = vertices[index + 2];
        double[] result = new double[4];
        Matrix.multiplyMV((double[])result, (int)0, (double[])transformationMatrix, (int)0, (double[])new double[]{x, y, z, 1.0}, (int)0);
        x = result[0];
        y = result[1];
        z = result[2];
        HashMapWrappedVirtualObject minBounds = (HashMapWrappedVirtualObject)geometryInfo.eGet((EStructuralFeature)GeometryPackage.eINSTANCE.getGeometryInfo_MinBounds());
        HashMapWrappedVirtualObject maxBounds = (HashMapWrappedVirtualObject)geometryInfo.eGet((EStructuralFeature)GeometryPackage.eINSTANCE.getGeometryInfo_MaxBounds());
        minBounds.set("x", (Object)Math.min(x, (Double)minBounds.eGet("x")));
        minBounds.set("y", (Object)Math.min(y, (Double)minBounds.eGet("y")));
        minBounds.set("z", (Object)Math.min(z, (Double)minBounds.eGet("z")));
        maxBounds.set("x", (Object)Math.max(x, (Double)maxBounds.eGet("x")));
        maxBounds.set("y", (Object)Math.max(y, (Double)maxBounds.eGet("y")));
        maxBounds.set("z", (Object)Math.max(z, (Double)maxBounds.eGet("z")));
        generateGeometryResult.setMinX(Math.min(x, generateGeometryResult.getMinX()));
        generateGeometryResult.setMinY(Math.min(y, generateGeometryResult.getMinY()));
        generateGeometryResult.setMinZ(Math.min(z, generateGeometryResult.getMinZ()));
        generateGeometryResult.setMaxX(Math.max(x, generateGeometryResult.getMaxX()));
        generateGeometryResult.setMaxY(Math.max(y, generateGeometryResult.getMaxY()));
        generateGeometryResult.setMaxZ(Math.max(z, generateGeometryResult.getMaxZ()));
    }

    void setTransformationMatrix(VirtualObject geometryInfo, double[] transformationMatrix) throws BimserverDatabaseException {
        ByteBuffer byteBuffer = ByteBuffer.allocate(128);
        byteBuffer.order(ByteOrder.nativeOrder());
        DoubleBuffer asDoubleBuffer = byteBuffer.asDoubleBuffer();
        for (double d : transformationMatrix) {
            asDoubleBuffer.put(d);
        }
        geometryInfo.setAttribute((EStructuralFeature)GeometryPackage.eINSTANCE.getGeometryInfo_Transformation(), (Object)byteBuffer.array());
    }

    public String getRenderEngineName() {
        return this.renderEngineName;
    }
}

