/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.longaction;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.bimserver.BimServer;
import org.bimserver.BimserverDatabaseException;
import org.bimserver.database.DatabaseSession;
import org.bimserver.database.OldQuery;
import org.bimserver.emf.QueryInterface;
import org.bimserver.longaction.LongActionKey;
import org.bimserver.models.store.CompareType;
import org.bimserver.models.store.ConcreteRevision;
import org.bimserver.models.store.Revision;

public class DownloadParameters
extends LongActionKey {
    private final DownloadType downloadType;
    private final BimServer bimServer;
    private Set<Long> roids;
    private boolean includeAllSubtypes;
    private Set<Long> oids;
    private Set<String> guids;
    private Set<String> names;
    private String jsonQuery;
    private Set<String> classNames;
    private long modelCompareIdentifier;
    private CompareType compareType;
    private long ignoreUoid = -1L;
    private String code;
    private long qeid;
    private long serializerOid;
    private boolean useObjectIDM;
    private OldQuery.Deep deep;
    private String schema;

    public DownloadParameters(BimServer bimServer, DownloadType downloadType) {
        this.bimServer = bimServer;
        this.downloadType = downloadType;
    }

    public void setSerializerOid(long serializerOid) {
        this.serializerOid = serializerOid;
    }

    public long getSerializerOid() {
        return this.serializerOid;
    }

    public long getIgnoreUoid() {
        return this.ignoreUoid;
    }

    public void setCompareType(CompareType compareType) {
        this.compareType = compareType;
    }

    public void setSchema(String schema) {
        this.schema = schema;
    }

    public void setNames(Set<String> names) {
        this.names = names;
    }

    public void setJsonQuery(String jsonQuery) {
        this.jsonQuery = jsonQuery;
    }

    public String getId() {
        return String.valueOf((long)this.hashCode() + Integer.MAX_VALUE);
    }

    public Set<Long> getRoids() {
        return this.roids;
    }

    public void setRoids(Set<Long> roids) {
        this.roids = roids;
    }

    public Long getRoid() {
        if (this.roids == null) {
            return null;
        }
        Iterator<Long> iterator = this.roids.iterator();
        return iterator.hasNext() ? iterator.next() : null;
    }

    public void setRoid(Long roid) {
        this.roids = new HashSet<Long>();
        this.roids.add(roid);
    }

    public Set<Long> getOids() {
        return this.oids;
    }

    public void setOids(Set<Long> oids) {
        this.oids = oids;
    }

    public long getModelCompareIdentifier() {
        return this.modelCompareIdentifier;
    }

    public CompareType getCompareType() {
        return this.compareType;
    }

    public Set<String> getGuids() {
        return this.guids;
    }

    public void setGuids(Set<String> guids) {
        this.guids = guids;
    }

    public Set<String> getClassNames() {
        return this.classNames;
    }

    public void setClassNames(Set<String> classNames) {
        this.classNames = classNames;
    }

    public DownloadType getDownloadType() {
        return this.downloadType;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.classNames == null ? 0 : this.classNames.hashCode());
        result = 31 * result + (this.code == null ? 0 : this.code.hashCode());
        result = 31 * result + (this.compareType == null ? 0 : this.compareType.name().hashCode());
        result = 31 * result + (this.deep == null ? 0 : this.deep.hashCode());
        result = 31 * result + (this.downloadType == null ? 0 : this.downloadType.name().hashCode());
        result = 31 * result + (this.guids == null ? 0 : this.guids.hashCode());
        result = 31 * result + (int)(this.ignoreUoid ^ this.ignoreUoid >>> 32);
        result = 31 * result + (this.includeAllSubtypes ? 1231 : 1237);
        result = 31 * result + (this.jsonQuery == null ? 0 : this.jsonQuery.hashCode());
        result = 31 * result + (int)(this.modelCompareIdentifier ^ this.modelCompareIdentifier >>> 32);
        result = 31 * result + (this.names == null ? 0 : this.names.hashCode());
        result = 31 * result + (this.oids == null ? 0 : this.oids.hashCode());
        result = 31 * result + (int)(this.qeid ^ this.qeid >>> 32);
        result = 31 * result + (this.roids == null ? 0 : this.roids.hashCode());
        result = 31 * result + (int)(this.serializerOid ^ this.serializerOid >>> 32);
        result = 31 * result + (this.useObjectIDM ? 1231 : 1237);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DownloadParameters other = (DownloadParameters)obj;
        if (this.classNames == null ? other.classNames != null : !this.classNames.equals(other.classNames)) {
            return false;
        }
        if (this.code == null ? other.code != null : !this.code.equals(other.code)) {
            return false;
        }
        if (this.compareType != other.compareType) {
            return false;
        }
        if (this.deep != other.deep) {
            return false;
        }
        if (this.downloadType != other.downloadType) {
            return false;
        }
        if (this.guids == null ? other.guids != null : !this.guids.equals(other.guids)) {
            return false;
        }
        if (this.ignoreUoid != other.ignoreUoid) {
            return false;
        }
        if (this.includeAllSubtypes != other.includeAllSubtypes) {
            return false;
        }
        if (this.jsonQuery == null ? other.jsonQuery != null : !this.jsonQuery.equals(other.jsonQuery)) {
            return false;
        }
        if (this.modelCompareIdentifier != other.modelCompareIdentifier) {
            return false;
        }
        if (this.names == null ? other.names != null : !this.names.equals(other.names)) {
            return false;
        }
        if (this.oids == null ? other.oids != null : !this.oids.equals(other.oids)) {
            return false;
        }
        if (this.qeid != other.qeid) {
            return false;
        }
        if (this.roids == null ? other.roids != null : !this.roids.equals(other.roids)) {
            return false;
        }
        if (this.serializerOid != other.serializerOid) {
            return false;
        }
        return this.useObjectIDM == other.useObjectIDM;
    }

    public String getFileName() {
        String extension = this.bimServer.getSerializerFactory().getExtension(this.serializerOid);
        return this.getFileNameWithoutExtension() + "." + extension;
    }

    public String getFileNameWithoutExtension() {
        switch (this.downloadType) {
            case DOWNLOAD_PROJECTS: {
                DatabaseSession session = this.bimServer.getDatabase().createSession();
                StringBuilder fileName = new StringBuilder();
                for (long roid : this.roids) {
                    try {
                        Revision revision = (Revision)session.get(session.getEClassForName("store", "Revision"), roid, (QueryInterface)OldQuery.getDefault());
                        for (ConcreteRevision concreteRevision : revision.getConcreteRevisions()) {
                            fileName.append(concreteRevision.getProject().getName() + "-");
                        }
                    }
                    catch (BimserverDatabaseException e) {
                        e.printStackTrace();
                    }
                }
                fileName.delete(fileName.length() - 1, fileName.length());
                return fileName.toString();
            }
            case DOWNLOAD_COMPARE: {
                return "compare";
            }
            case DOWNLOAD_BY_NEW_JSON_QUERY: {
                DatabaseSession session = this.bimServer.getDatabase().createSession();
                StringBuilder fileName = new StringBuilder();
                for (long roid : this.roids) {
                    try {
                        Revision revision = (Revision)session.get(session.getEClassForName("store", "Revision"), roid, (QueryInterface)OldQuery.getDefault());
                        for (ConcreteRevision concreteRevision : revision.getConcreteRevisions()) {
                            fileName.append(concreteRevision.getProject().getName() + "-");
                        }
                    }
                    catch (BimserverDatabaseException e) {
                        e.printStackTrace();
                    }
                }
                fileName.delete(fileName.length() - 1, fileName.length());
                return fileName.toString();
            }
        }
        return "unknown";
    }

    public boolean isIncludeAllSubtypes() {
        return this.includeAllSubtypes;
    }

    public void setIncludeAllSubtypes(boolean includeAllSubtypes) {
        this.includeAllSubtypes = includeAllSubtypes;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public long getQeid() {
        return this.qeid;
    }

    public void setQeid(long qeid) {
        this.qeid = qeid;
    }

    public void setModelCompareIdentifier(long modelCompareIdentifier) {
        this.modelCompareIdentifier = modelCompareIdentifier;
    }

    public boolean getUseObjectIDM() {
        return this.useObjectIDM;
    }

    public void setUseObjectIDM(Boolean useObjectIDM) {
        this.useObjectIDM = useObjectIDM;
    }

    public OldQuery.Deep getDeep() {
        return this.deep;
    }

    public void setDeep(OldQuery.Deep deep) {
        this.deep = deep;
    }

    public Set<String> getNames() {
        return this.names;
    }

    public String getJsonQuery() {
        return this.jsonQuery;
    }

    public String getSchema() {
        return this.schema;
    }

    public static enum DownloadType {
        DOWNLOAD_PROJECTS,
        DOWNLOAD_COMPARE,
        DOWNLOAD_BY_NEW_JSON_QUERY;

    }
}

