/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.longaction;

import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicInteger;
import org.bimserver.BimServer;
import org.bimserver.database.actions.ProgressListener;
import org.bimserver.longaction.LongActionKey;
import org.bimserver.models.store.ActionState;
import org.bimserver.models.store.LongActionState;
import org.bimserver.models.store.StoreFactory;
import org.bimserver.notifications.ProgressNotification;
import org.bimserver.notifications.ProgressTopic;
import org.bimserver.plugins.Reporter;
import org.bimserver.webservices.authorization.Authorization;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class LongAction<T extends LongActionKey>
implements Reporter,
ProgressListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(LongAction.class);
    private final GregorianCalendar start;
    private final AtomicInteger progress = new AtomicInteger(-1);
    private final CountDownLatch latch = new CountDownLatch(1);
    private final BimServer bimServer;
    private final String username;
    private final String userUsername;
    private ActionState actionState = ActionState.UNKNOWN;
    private GregorianCalendar stop;
    private final List<String> errors = new ArrayList<String>();
    private final List<String> warnings = new ArrayList<String>();
    private final List<String> infos = new ArrayList<String>();
    private final Authorization authorization;
    private String title = "Unknown";
    private int stage = 0;
    private ProgressTopic progressTopic;

    public LongAction(BimServer bimServer, String username, String userUsername, Authorization authorization) {
        this.start = new GregorianCalendar();
        this.authorization = authorization;
        this.userUsername = userUsername;
        this.username = username;
        this.bimServer = bimServer;
        this.actionState = ActionState.STARTED;
    }

    public void init(Thread thread) {
    }

    public void setProgressTopic(ProgressTopic progressTopic) {
        this.progressTopic = progressTopic;
    }

    public ProgressTopic getProgressTopic() {
        return this.progressTopic;
    }

    protected void changeActionState(ActionState actiontState, String title, int progress) {
        ActionState oldState = this.actionState;
        if (actiontState == ActionState.FINISHED) {
            this.stop = new GregorianCalendar();
        }
        int oldProgress = this.progress.get();
        String oldTitle = this.title;
        this.title = title;
        this.progress.set(progress);
        this.actionState = actiontState;
        if (oldState != actiontState || progress != oldProgress || !oldTitle.equals(title)) {
            if (title != null && oldTitle != null && !title.equals(oldTitle)) {
                ++this.stage;
            }
            this.bimServer.getNotificationsManager().notify(new ProgressNotification(this.bimServer, this.progressTopic, this.getState()));
        }
    }

    public GregorianCalendar getStop() {
        return this.stop;
    }

    public ActionState getActionState() {
        return this.actionState;
    }

    public String getUserUsername() {
        return this.userUsername;
    }

    public Authorization getAuthorization() {
        return this.authorization;
    }

    public BimServer getBimServer() {
        return this.bimServer;
    }

    public abstract String getDescription();

    public abstract void execute();

    public String getUserName() {
        return this.username;
    }

    protected void done() {
        this.bimServer.getNotificationsManager().notify(new ProgressNotification(this.bimServer, this.progressTopic, this.getState()));
        this.latch.countDown();
    }

    public void waitForCompletion() {
        try {
            this.latch.await();
        }
        catch (InterruptedException e) {
            LOGGER.error("", (Throwable)e);
        }
    }

    public GregorianCalendar getStart() {
        return this.start;
    }

    @Override
    public void updateProgress(String title, int progress) {
        int oldProgress = this.progress.get();
        String oldTitle = this.title;
        this.title = title;
        this.progress.set(progress);
        if (progress != oldProgress || !oldTitle.equals(title)) {
            if (!title.equals(oldTitle)) {
                ++this.stage;
            }
            this.bimServer.getNotificationsManager().notify(new ProgressNotification(this.bimServer, this.progressTopic, this.getState()));
        }
    }

    public void terminate() {
        LOGGER.info("Terminating long action with id " + this.progressTopic.getKey().getId());
    }

    public int getProgress() {
        return this.progress.get();
    }

    public synchronized LongActionState getState() {
        LongActionState ds = StoreFactory.eINSTANCE.createLongActionState();
        ds.setStart(this.getStart().getTime());
        ds.setEnd(this.getStop() != null ? this.getStop().getTime() : null);
        ds.setProgress(Integer.valueOf(this.getProgress()));
        ds.setState(this.getActionState());
        ds.setTitle(this.title);
        ds.setStage(this.stage);
        ds.getErrors().addAll(this.errors);
        ds.getInfos().addAll(this.infos);
        ds.getWarnings().addAll(this.warnings);
        if (this.getActionState() == ActionState.FINISHED) {
            ds.setProgress(Integer.valueOf(100));
        }
        return ds;
    }

    public List<String> getErrors() {
        return this.errors;
    }

    public void error(Throwable error) {
        if (error == null) {
            LOGGER.error("Unknown error");
            this.changeActionState(ActionState.AS_ERROR, "Unknown Error", 0);
        } else {
            LOGGER.error("", error);
            this.errors.add(error.getMessage());
            this.stop = new GregorianCalendar();
            this.changeActionState(ActionState.AS_ERROR, error == null ? "Unknown Error" : error.getMessage(), 0);
        }
    }

    public void warning(String warning) {
        this.warnings.add(warning);
    }

    public void info(String info) {
        this.infos.add(info);
    }

    public void stop() {
        this.progressTopic.remove();
    }
}

