/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.longaction;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.util.GregorianCalendar;
import java.util.Iterator;
import org.bimserver.longaction.CannotBeScheduledException;
import org.bimserver.longaction.LongAction;
import org.bimserver.models.store.ActionState;
import org.bimserver.shared.exceptions.UserException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LongActionManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(LongActionManager.class);
    private static final int FIVE_MINUTES_IN_MS = 300000;
    private final BiMap<Long, LongAction<?>> actions = HashBiMap.create();
    private volatile boolean running = true;

    public synchronized void start(final LongAction<?> longAction) throws CannotBeScheduledException {
        if (!this.running) {
            throw new CannotBeScheduledException();
        }
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                longAction.execute();
            }
        }, "LongAction Runner");
        longAction.init(thread);
        thread.setDaemon(true);
        thread.setName(longAction.getDescription());
        this.actions.put((Object)longAction.getProgressTopic().getKey().getId(), longAction);
        thread.start();
    }

    public synchronized void shutdown() {
        this.running = false;
    }

    public synchronized LongAction<?> getLongAction(long id) {
        return (LongAction)this.actions.get((Object)id);
    }

    public synchronized void cleanup() {
        Iterator iterator = this.actions.keySet().iterator();
        GregorianCalendar now = new GregorianCalendar();
        while (iterator.hasNext()) {
            long id = (Long)iterator.next();
            LongAction longAction = (LongAction)this.actions.get((Object)id);
            if (longAction.getActionState() != ActionState.FINISHED) continue;
            GregorianCalendar stop = longAction.getStop();
            if (now.getTimeInMillis() - stop.getTimeInMillis() <= 300000L) continue;
            LOGGER.info("[AUTO] Cleaning up topic " + longAction.getProgressTopic().getKey().getId() + " (" + longAction.getDescription() + ")");
            iterator.remove();
        }
    }

    public synchronized void shutdownGracefully() {
        this.running = false;
        for (LongAction longAction : this.actions.values()) {
            longAction.waitForCompletion();
        }
    }

    public synchronized void remove(long topicId) throws UserException {
        LongAction longAction = (LongAction)this.actions.get((Object)topicId);
        if (longAction == null) {
            throw new UserException("No Topic with TopicId " + topicId + " found");
        }
        LOGGER.debug("[MAN] Cleaning up topic " + longAction.getProgressTopic().getKey().getId() + " (" + longAction.getDescription() + ")");
        longAction.stop();
        this.actions.remove((Object)topicId);
    }

    public synchronized void remove(LongAction<?> action) {
        LOGGER.debug("Cleaning up topics: " + action.getDescription());
        action.stop();
        this.actions.inverse().remove(action);
    }
}

