/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.longaction;

import org.bimserver.BimServer;
import org.bimserver.database.DatabaseSession;
import org.bimserver.database.ProgressHandler;
import org.bimserver.database.actions.AbstractBranchDatabaseAction;
import org.bimserver.database.actions.BimDatabaseAction;
import org.bimserver.database.berkeley.BimserverConcurrentModificationDatabaseException;
import org.bimserver.interfaces.objects.SProgressTopicType;
import org.bimserver.longaction.LongAction;
import org.bimserver.longaction.LongCheckinActionKey;
import org.bimserver.models.store.ActionState;
import org.bimserver.models.store.ConcreteRevision;
import org.bimserver.shared.exceptions.UserException;
import org.bimserver.webservices.authorization.Authorization;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LongBranchAction
extends LongAction<LongCheckinActionKey> {
    private static final Logger LOGGER = LoggerFactory.getLogger(LongBranchAction.class);
    private BimDatabaseAction<ConcreteRevision> action;

    public LongBranchAction(BimServer bimServer, String username, String userUsername, Authorization authorization, AbstractBranchDatabaseAction action) {
        super(bimServer, username, userUsername, authorization);
        this.setProgressTopic(bimServer.getNotificationsManager().createProgressOnProjectTopic(authorization.getUoid(), action.getPoid(), SProgressTopicType.BRANCH, "Branching"));
        this.action = action;
    }

    @Override
    public String getDescription() {
        return "Branch to new project";
    }

    @Override
    public void execute() {
        DatabaseSession session = this.getBimServer().getDatabase().createSession();
        try {
            this.action.setDatabaseSession(session);
            session.executeAndCommitAction(this.action, new ProgressHandler(){
                private int count;

                @Override
                public void progress(int current, int max) {
                    if (this.count == 0) {
                        LongBranchAction.this.updateProgress("Storing data...", current * 100 / max);
                    } else {
                        LongBranchAction.this.updateProgress("Storing data (" + (this.count + 1) + ")...", current * 100 / max);
                    }
                }

                @Override
                public void retry(int count) {
                    this.count = count;
                }
            });
        }
        catch (Exception e) {
            if (!(e instanceof UserException) && !(e instanceof BimserverConcurrentModificationDatabaseException)) {
                LOGGER.error("", (Throwable)e);
            }
            this.error(e);
        }
        finally {
            session.close();
            this.done();
            if (this.getActionState() != ActionState.AS_ERROR) {
                this.changeActionState(ActionState.FINISHED, "Done", 100);
            }
        }
    }
}

