/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.longaction;

import org.bimserver.BimServer;
import org.bimserver.BimserverDatabaseException;
import org.bimserver.database.DatabaseSession;
import org.bimserver.database.ProgressHandler;
import org.bimserver.database.RollbackListener;
import org.bimserver.database.actions.ProjectBasedDatabaseAction;
import org.bimserver.database.berkeley.BimserverConcurrentModificationDatabaseException;
import org.bimserver.interfaces.objects.SProgressTopicType;
import org.bimserver.longaction.LongAction;
import org.bimserver.longaction.LongActionKey;
import org.bimserver.longaction.LongStreamingCheckinAction;
import org.bimserver.models.store.ActionState;
import org.bimserver.shared.exceptions.UserException;
import org.bimserver.webservices.authorization.Authorization;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LongGenericAction
extends LongAction<LongActionKey> {
    private static final Logger LOGGER = LoggerFactory.getLogger(LongStreamingCheckinAction.class);
    private String fileName;
    private ProjectBasedDatabaseAction<?> action;

    public LongGenericAction(Long topicId, BimServer bimServer, String username, String userUsername, Authorization authorization, ProjectBasedDatabaseAction<?> action) {
        super(bimServer, username, userUsername, authorization);
        this.action = action;
        this.fileName = action.getFileName();
        if (topicId != -1L) {
            this.setProgressTopic(bimServer.getNotificationsManager().getProgressTopic(topicId));
        } else {
            this.setProgressTopic(bimServer.getNotificationsManager().createProgressOnProjectTopic(authorization.getUoid(), action.getPoid(), SProgressTopicType.UPLOAD, "Checkin"));
        }
        action.addProgressListener(this);
    }

    public LongGenericAction(BimServer bimServer, String username, String userUsername, Authorization authorization, ProjectBasedDatabaseAction<?> checkinDatabaseAction) {
        this(-1L, bimServer, username, userUsername, authorization, checkinDatabaseAction);
    }

    @Override
    public void execute() {
        DatabaseSession session = this.getBimServer().getDatabase().createSession();
        try {
            this.action.setDatabaseSession(session);
            session.executeAndCommitAction(this.action, new ProgressHandler(){
                private int count;

                @Override
                public void progress(int current, int max) {
                    if (this.count == 0) {
                        LongGenericAction.this.updateProgress("Saving to database (" + LongGenericAction.this.fileName + ")", current * 100 / max);
                    } else {
                        LongGenericAction.this.updateProgress("Saving to database (" + LongGenericAction.this.fileName + ", " + this.count + " try)", current * 100 / max);
                    }
                }

                @Override
                public void retry(int count) {
                    this.count = count;
                }
            }, new RollbackListener(){

                @Override
                public void rollback() {
                    try {
                        LongGenericAction.this.action.rollback();
                    }
                    catch (BimserverDatabaseException e) {
                        LOGGER.error("", (Throwable)e);
                    }
                }
            });
        }
        catch (Exception e) {
            if (!(e instanceof UserException) && !(e instanceof BimserverConcurrentModificationDatabaseException)) {
                LOGGER.error("", (Throwable)e);
            }
            this.error(e);
        }
        finally {
            try {
                this.action.close();
            }
            catch (Exception e) {
                LOGGER.error("", (Throwable)e);
            }
            session.close();
            if (this.getActionState() != ActionState.AS_ERROR) {
                this.changeActionState(ActionState.FINISHED, this.action.doneMessage(), 100);
            }
            this.done();
        }
    }

    @Override
    protected void done() {
        super.done();
        this.action = null;
    }

    @Override
    public String getDescription() {
        return this.getClass().getSimpleName();
    }
}

